//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : XmlUtil.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: XmlUtil.java,v 1.1.1.1 2004/03/03 15:24:03 k-imoto Exp $
//====================================================================
package KiWeb.Util;

import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.*;
import java.util.*;
import java.io.*;

//--------------------------------------------------------------------
// WEB LINK CLASS
//--------------------------------------------------------------------
public class XmlUtil
{
    DocumentBuilder mBuilder;
    Transformer     mTransformer;
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public XmlUtil()
        throws ParserConfigurationException, 
               TransformerConfigurationException
    {
        DocumentBuilderFactory aFactory = 
            DocumentBuilderFactory.newInstance();
        mBuilder = aFactory.newDocumentBuilder();
        
        TransformerFactory aTf = TransformerFactory.newInstance();
        mTransformer = aTf.newTransformer();
        mTransformer.setOutputProperty("indent", "yes");
        mTransformer.setOutputProperty("encoding", "Shift_JIS");
    }
    
    //----------------------------------------------------------------
    // t@C̓ǂݍ
    //----------------------------------------------------------------
    public Document load(String inFileName)
    {
        return load(new File(inFileName));
    }
    public Document load(File inFile)
    {
        Document aDoc = null;
        try {
            aDoc = mBuilder.parse(inFile);
        } catch (Exception e) {
            aDoc = mBuilder.newDocument();
        }
        return aDoc;
    }

    //----------------------------------------------------------------
    // t@Cւ̏o
    //----------------------------------------------------------------
    public void save(Document inDoc, String inFileName)
    {
        save(inDoc, new File(inFileName));
    }
    public void save(Document inDoc, File inFile)
    {
        try {
            FileOutputStream aFos = new FileOutputStream(inFile);
            save(inDoc, aFos);
            aFos.flush();
            aFos.close();
        } catch (Exception e) {
        }
    }
    public void save(Document inDoc, OutputStream inOut)
    {
        try {
            Source aSource = new DOMSource(inDoc);
            Result aResult = new StreamResult(inOut);
            mTransformer.transform(aSource, aResult);
        } catch (Exception e) {
        }
    }
    
    //----------------------------------------------------------------
    // wpX̎o
    //----------------------------------------------------------------
    public Vector getElements(Element inElem, String inName)
    {
        Vector  aVec = new Vector();
        NodeList aList = inElem.getElementsByTagName(inName);
        for (int i = 0; i < aList.getLength(); i++) {
            aVec.add((Element)aList.item(i));
        }
        return aVec;
    }
    
    //----------------------------------------------------------------
    // Element ̃eLXgm[h̒l擾
    //----------------------------------------------------------------
    public String getElementValue(Element inElem)
    {
        String aValue = null;
        if (inElem.getFirstChild() != null) {
            aValue = inElem.getFirstChild().getNodeValue();
        }
        return aValue;
    }
    
    //----------------------------------------------------------------
    // DocumentɃ[gm[hǉ
    //----------------------------------------------------------------
    public Element appendChild(Document inDoc,
                               String   inName)
    {
        Element aNewElem = inDoc.createElement(inName);
        inDoc.appendChild(aNewElem);
        return aNewElem;
    }

    //----------------------------------------------------------------
    // qm[hǉ
    //----------------------------------------------------------------
    public Element appendChild(Document inDoc,
                               Element  inElem,
                               String   inName)
    {
        Element aNewElem = inDoc.createElement(inName);
        inElem.appendChild(aNewElem);
        return aNewElem;
    }

    //----------------------------------------------------------------
    // qm[hǉ (eLXgm[htj
    //----------------------------------------------------------------
    public Element appendChild(Document inDoc,
                               Element  inElem,
                               String   inName,
                               String   inValue)
    {
        Element aNewElem = appendChild(inDoc, inElem, inName);
        aNewElem.appendChild(inDoc.createTextNode(inValue));
        return aNewElem;
    }
    
/*
    public static final void main(String args[])
    {
        try {
            XmlUtil xml = new XmlUtil();
            Document doc = xml.load("test.xml");
            if (doc.getDocumentElement() == null) {
                Element elem = xml.appendChild(doc, "test");
                xml.appendChild(doc, elem, "item", "0");
                xml.appendChild(doc, elem, "item", "eXg");
            }
            xml.save(doc, "test.xml");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
*/
}