/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import fortest.tc.ArrayUser;
import java.io.File;
import java.util.Vector;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.CodeReader;

public class ClassNameResolverTest
extends TestCase {
    ClassNameResolver cnr;

    protected void setUp() throws Exception {
        super.setUp();
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\tc\\ArrayUserTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        this.cnr = new ClassNameResolver(ta.getTestClass().packageName(), ta.getTestClass().getImports());
    }

    public void test\u30af\u30e9\u30b9\u306e\u30d5\u30eb\u30cd\u30fc\u30e0\u5019\u88dc\u304c\u53d6\u5f97\u3067\u304d\u3066\u3044\u308b\u304b() {
        Vector names = this.cnr.getListFullClassNames("Token");
        ClassNameResolverTest.assertEquals((int)1, (int)names.size());
        ClassNameResolverTest.assertEquals((String)"org.kikaineko.source.util.Token", (String)((String)names.get(0)));
        names = this.cnr.getListFullClassNames("Hoge");
        ClassNameResolverTest.assertEquals((int)2, (int)names.size());
        ClassNameResolverTest.assertEquals((String)"fortest.tc.Hoge", (String)((String)names.get(0)));
        ClassNameResolverTest.assertEquals((String)"java.lang.Hoge", (String)((String)names.get(1)));
    }

    public void testGetClazz() {
        ClassNameResolverTest.assertEquals(Integer.TYPE, (Object)this.cnr.getClazz("int"));
        ClassNameResolverTest.assertEquals(Integer.TYPE, (Object)this.cnr.getClazz("int"));
        ClassNameResolverTest.assertEquals(String.class, (Object)this.cnr.getClazz("String"));
        ClassNameResolverTest.assertEquals(TestCase.class, (Object)this.cnr.getClazz("TestCase"));
        ClassNameResolverTest.assertEquals(Token.class, (Object)this.cnr.getClazz("Token"));
        ClassNameResolverTest.assertEquals(ArrayUser.class, (Object)this.cnr.getClazz("ArrayUser"));
    }
}

