/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.Vector;
import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.MethodSeacher;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.mock.util.Operator;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;

public class SmallInterpreter
implements Analyst {
    private int index;
    private TestClass tc;
    private VariableTable vt;
    private TokenArray ta;
    private Stack stackVal;
    private TypeOwner stackType;
    private int currentLevel = 0;
    private String targetName;
    private TargetClass target;
    protected StringBuffer history;
    protected StringBuffer setUpHistory;
    private VariableTable setUpVt;
    private ClassNameResolver cnr;
    private String lastCallintTargetMethodName;

    public SmallInterpreter(TestClass tc, TargetClass tar) {
        this.target = tar;
        this.tc = tc;
        this.targetName = this.target.getInstanceName();
        this.cnr = new ClassNameResolver(tc.packageName(), tc.getImports());
    }

    public void analyze() throws Exception {
        try {
            this.setUpanalyze();
            int i = 0;
            while (i < this.tc.howManyTestMethods()) {
                this.analyze(i);
                ++i;
            }
            this.target.setUsedConcreteClasses(this.stackType.pushedConcreteClasses());
        }
        catch (Throwable t) {
            String message = "";
            message = this.index >= 2 ? String.valueOf(this.ta.getVal(this.index - 2)) + " " + this.ta.getVal(this.index - 1) + " " + this.ta.getVal(this.index) : (this.index >= 1 ? String.valueOf(this.ta.getVal(this.index - 1)) + " " + this.ta.getVal(this.index) : this.ta.getVal(this.index));
            throw new Exception("\"" + message + "\" has a bad word.");
        }
    }

    protected void setUpanalyze() {
        if (this.setUpHistory == null) {
            this.vt = new VariableTable();
            this.stackVal = new Stack();
            this.stackType = new TypeOwner();
            this.history = new StringBuffer();
            this.ta = this.tc.getSetUp().getTokenArray();
            this.index = this.ta.indexOfVal("{");
            ++this.index;
            this.block();
            this.setUpHistory = this.history;
            this.setUpVt = this.vt;
        }
    }

    protected void analyze(int i) {
        this.stackVal = new Stack();
        this.stackType = new TypeOwner(this.stackType.getPushedVec());
        this.vt = new VariableTable();
        this.history = new StringBuffer(this.setUpHistory.toString());
        this.ta = this.tc.getTestMethod(i).getTokenArray();
        this.index = this.ta.indexOfVal("{");
        ++this.index;
        this.block();
    }

    private void block() {
        ++this.currentLevel;
        this.blockBody();
        --this.currentLevel;
    }

    private void blockBody() {
        while (true) {
            String s;
            if (!(s = this.ta.getVal(this.index++)).equals(this.targetName) && this.isVariable(s)) {
                Class c = this.cnr.getClazz(s);
                this.variable(c);
                continue;
            }
            if (s.equals("}")) break;
            this.statement(s);
        }
    }

    private int setArray() {
        Token t;
        ++this.index;
        int depth = 0;
        while ((t = this.ta.getToken(this.index)).getKind() != 22) {
            if (t.getKind() == 48) {
                ++this.index;
                continue;
            }
            ++depth;
            this.expression();
        }
        ++this.index;
        return depth;
    }

    private void setVariableArray(String name) {
        if (this.ta.getVal(this.index).equals("new")) {
            this.expression();
            Object o = this.stackVal.pop();
            this.stackType.pop();
            this.vt.setValAndLevel(name, o, this.currentLevel);
        } else if (this.ta.getVal(this.index).equals("{")) {
            int leng = this.setArray();
            Object[] os = new Object[leng];
            int i = leng - 1;
            while (i >= 0) {
                os[i] = this.stackVal.pop();
                this.stackType.pop();
                --i;
            }
            this.vt.setValAndLevel(name, os, this.currentLevel);
        }
    }

    private void variable(Class type) {
        Token t;
        if ((t = this.ta.getToken(this.index++)).getKind() != 19) {
            Token t2;
            String name = t.getVal();
            if ((t2 = this.ta.getToken(this.index++)).getKind() != 19) {
                String s = t2.getVal();
                this.vt.addVariable(name, type, this.currentLevel);
                if (s.equals("=")) {
                    this.expression();
                    Object o = this.stackVal.pop();
                    this.stackType.pop();
                    this.vt.setValAndLevel(name, o, this.currentLevel);
                }
            } else {
                ++this.index;
                this.vt.addVariable(name, ClassNameResolver.getArrayClass(type), this.currentLevel);
                String s = this.ta.getVal(this.index++);
                if (s.equals("=")) {
                    this.setVariableArray(name);
                }
            }
        } else {
            String name;
            ++this.index;
            if ((name = this.ta.getVal(this.index++)).equals("[")) {
                --this.index;
                this.variable(ClassNameResolver.getArrayClass(type));
            } else {
                this.vt.addVariable(name, ClassNameResolver.getArrayClass(type), this.currentLevel);
            }
            String s = this.ta.getVal(this.index++);
            if (s.equals("=")) {
                this.setVariableArray(name);
            }
        }
        if (this.ta.getVal(this.index).equals(",")) {
            ++this.index;
            this.variable(type);
        }
    }

    private void expression() {
        this.term();
        while (true) {
            Token t;
            if ((t = this.ta.getToken(this.index)).getKind() == 8) {
                ++this.index;
                this.term();
                this.stackVal.push(Operator.operate(this.stackVal.pop(), this.stackVal.pop(), "+"));
                this.stackType.push(Operator.strongType(this.stackType.pop(), this.stackType.pop()));
                continue;
            }
            if (t.getKind() != 9) break;
            ++this.index;
            this.term();
            this.stackVal.push(Operator.operate(this.stackVal.pop(), this.stackVal.pop(), "-"));
            this.stackType.push(Operator.strongType(this.stackType.pop(), this.stackType.pop()));
        }
    }

    private void term() {
        this.factor();
        while (true) {
            Token t;
            if ((t = this.ta.getToken(this.index)).getKind() == 6) {
                ++this.index;
                this.factor();
                this.stackVal.push(Operator.operate(this.stackVal.pop(), this.stackVal.pop(), "*"));
                this.stackType.push(Operator.strongType(this.stackType.pop(), this.stackType.pop()));
                continue;
            }
            if (t.getKind() != 7) break;
            ++this.index;
            this.factor();
            this.stackVal.push(Operator.operate(this.stackVal.pop(), this.stackVal.pop(), "/"));
            this.stackType.push(Operator.strongType(this.stackType.pop(), this.stackType.pop()));
        }
    }

    private void numberPush(Token t) {
        String s = this.ta.getVal(this.index);
        if (s.equals("l") || s.equals("L")) {
            ++this.index;
            this.stackVal.push(new Long(t.getVal()));
            this.stackType.push(Long.TYPE);
        } else if (s.equals("d") || s.equals("D")) {
            ++this.index;
            this.stackVal.push(new Double(t.getVal()));
            this.stackType.push(Double.TYPE);
        } else if (s.equals("f") || s.equals("F")) {
            ++this.index;
            this.stackVal.push(new Float(t.getVal()));
            this.stackType.push(Float.TYPE);
        } else if (s.equals(".")) {
            this.afterPiriodPush(t);
        } else {
            this.stackVal.push(new Integer(t.getVal()));
            this.stackType.push(Integer.TYPE);
        }
    }

    private void afterPiriodPush(Token t) {
        ++this.index;
        Token tt = this.ta.getToken(this.index);
        Token tt2 = this.ta.getToken(this.index + 1);
        if (tt.getKind() == 1) {
            if (tt2.getVal().equals("f") || tt2.getVal().equals("F")) {
                this.index += 2;
                this.stackVal.push(new Float(String.valueOf(t.getVal()) + "." + tt.getVal()));
                this.stackType.push(Float.TYPE);
            } else if (tt2.getVal().equals("d") || tt2.getVal().equals("D")) {
                this.index += 2;
                this.stackVal.push(new Double(String.valueOf(t.getVal()) + "." + tt.getVal()));
                this.stackType.push(Double.TYPE);
            } else {
                ++this.index;
                this.stackVal.push(new Double(String.valueOf(t.getVal()) + "." + tt.getVal()));
                this.stackType.push(Double.TYPE);
            }
        } else if (tt.getVal().equals("f") || tt.getVal().equals("F")) {
            this.stackVal.push(new Float(String.valueOf(t.getVal()) + "." + tt.getVal()));
            this.stackType.push(Float.TYPE);
        } else {
            this.stackVal.push(new Double(t.getVal()));
            this.stackType.push(Double.TYPE);
        }
    }

    private void method(String type) {
        Object[] oss;
        String name = this.ta.getVal(this.index++);
        Object[] argsO = null;
        Class[] cs = null;
        if (this.ta.getVal(this.index).equals("(") && (oss = this.arg()) != null) {
            argsO = (Object[])oss[0];
            cs = (Class[])oss[1];
        }
        try {
            Object ro = null;
            if (type.equals("method")) {
                Object o = this.stackVal.pop();
                this.stackType.pop();
                Class<?> clazz = o.getClass();
                Method m = MethodSeacher.search(clazz, name, cs);
                ro = m.invoke(o, argsO);
                this.stackType.push(m.getReturnType());
            } else {
                Class clazz = this.cnr.getClazz(name);
                Constructor csr = clazz.getConstructor(cs);
                ro = csr.newInstance(argsO);
                this.stackType.push(ro.getClass());
            }
            this.stackVal.push(ro);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ++this.index;
        if (this.ta.getVal(this.index).equals(".")) {
            ++this.index;
            this.method("method");
        }
    }

    private Object[] arg() {
        Vector vec = new Vector();
        Vector cvec = new Vector();
        ++this.index;
        if (this.ta.getVal(this.index).equals(")")) {
            Object[] oss = new Object[2];
            return oss;
        }
        while (true) {
            this.expression();
            vec.add(this.stackVal.pop());
            cvec.add(this.stackType.pop());
            String s = this.ta.getVal(this.index);
            if (s.equals(")")) break;
            if (!s.equals(",")) continue;
            ++this.index;
        }
        Object[] os = new Object[vec.size()];
        Class[] cs = new Class[cvec.size()];
        int i = 0;
        while (i < os.length) {
            os[i] = vec.get(i);
            cs[i] = (Class)cvec.get(i);
            ++i;
        }
        Object[] oss = new Object[]{os, cs};
        return oss;
    }

    private void constructor() {
        this.method("const");
    }

    private void arrayGenerate() {
        String type = this.ta.getVal(this.index++);
        ++this.index;
        this.expression();
        Object o = this.stackVal.pop();
        this.stackType.pop();
        Object os = Array.newInstance(this.cnr.getClazz(type), ((Number)o).intValue());
        this.stackVal.push(os);
        this.stackType.push(os.getClass());
    }

    private void variablePush(Token t) {
        this.stackType.push(this.vt.getType(t.getVal()));
        this.stackVal.push(this.vt.getVal(t.getVal()));
    }

    private void factor() {
        Token t;
        if ((t = this.ta.getToken(this.index++)).getKind() == 1) {
            this.numberPush(t);
        } else if (t.getKind() == 4) {
            if (this.vt.include(t.getVal())) {
                this.variablePush(t);
                if (this.ta.getVal(this.index).equals(".")) {
                    ++this.index;
                    this.method("method");
                } else if (this.ta.getVal(this.index).equals("[")) {
                    ++this.index;
                    this.expression();
                    int i = ((Number)this.stackVal.pop()).intValue();
                    this.stackType.pop();
                    this.stackVal.push(Array.get(this.vt.getVal(t.getVal()), i));
                    this.stackType.push(LangMgn.unitTypeInArray(this.vt.getType(t.getVal())));
                } else if (this.ta.getVal(this.index).equals("++")) {
                    ++this.index;
                    Object ro = Operator.operate(new Integer(1), this.stackVal.peek(), "+");
                    this.vt.setVal(t.getVal(), ro);
                } else if (this.ta.getVal(this.index).equals("--")) {
                    ++this.index;
                    Object ro = Operator.operate(new Integer(1), this.stackVal.peek(), "-");
                    this.vt.setVal(t.getVal(), ro);
                }
            } else if (t.getVal().equals("true")) {
                this.stackVal.push(new Boolean(true));
                this.stackType.push(Boolean.TYPE);
            } else if (t.getVal().equals("false")) {
                this.stackVal.push(new Boolean(false));
                this.stackType.push(Boolean.TYPE);
            } else if (t.getVal().equals("new")) {
                if (this.ta.getVal(this.index + 1).equals("[")) {
                    this.arrayGenerate();
                } else {
                    this.constructor();
                }
            } else if (t.getVal().equals("null")) {
                this.stackVal.push(null);
                this.stackType.push((Object)null);
            }
        } else if (t.getKind() == 9) {
            this.factor();
            Object o = this.stackVal.pop();
            this.negatePush(o);
        } else if (t.getKind() == 13) {
            this.expression();
            ++this.index;
        } else if (t.getKind() == 16) {
            this.stackVal.push(this.ta.getVal(this.index++));
            this.stackType.push(String.class);
            ++this.index;
        } else if (t.getKind() == 17) {
            this.stackVal.push(new Character(this.ta.getVal(this.index++).charAt(0)));
            this.stackType.push(Character.TYPE);
            ++this.index;
        } else if (t.getKind() == 24) {
            this.factor();
            Object o = this.stackVal.pop();
            this.negatePush(o);
        } else if (t.getKind() == 10) {
            Token tt = this.ta.getToken(this.index++);
            this.variablePush(tt);
            Object ro = Operator.operate(new Integer(1), this.stackVal.pop(), "+");
            this.vt.setVal(tt.getVal(), ro);
            this.stackVal.push(ro);
        } else if (t.getKind() == 11) {
            Token tt = this.ta.getToken(this.index++);
            this.variablePush(tt);
            Object ro = Operator.operate(new Integer(1), this.stackVal.pop(), "-");
            this.vt.setVal(tt.getVal(), ro);
            this.stackVal.push(ro);
        }
    }

    private void negatePush(Object o) {
        if (o instanceof Integer) {
            this.stackVal.push(new Integer(-((Integer)o).intValue()));
        } else if (o instanceof Long) {
            this.stackVal.push(new Long(-((Long)o).longValue()));
        } else if (o instanceof Float) {
            this.stackVal.push(new Float(-((Float)o).floatValue()));
        } else if (o instanceof Double) {
            this.stackVal.push(new Double(-((Double)o).doubleValue()));
        } else if (o instanceof Boolean) {
            this.stackVal.push(new Boolean((Boolean)o == false));
        }
    }

    private void statement(String s) {
        if (this.vt.include(s)) {
            Token t;
            if ((t = this.ta.getToken(this.index++)).getKind() == 5) {
                this.expression();
                this.vt.setVal(s, this.stackVal.pop());
            } else if (t.getKind() == 15) {
                this.stackVal.push(this.vt.getVal(s));
                this.stackType.push(this.vt.getType(s));
                this.method("method");
            } else if (t.getKind() == 19) {
                this.expression();
                int i = ((Number)this.stackVal.pop()).intValue();
                this.stackType.pop();
                ++this.index;
                ++this.index;
                this.expression();
                Object o = this.stackVal.pop();
                this.stackType.pop();
                Array.set(this.vt.getVal(s), i, o);
            } else if (t.getKind() == 10) {
                Object o = this.vt.getVal(s);
                this.stackVal.push(o);
                this.stackType.push(this.vt.getType(s));
                Object ro = Operator.operate(new Integer(1), o, "+");
                this.vt.setVal(s, ro);
            } else if (t.getKind() == 11) {
                Object o = this.vt.getVal(s);
                this.stackVal.push(o);
                this.stackType.push(this.vt.getType(s));
                Object ro = Operator.operate(new Integer(1), o, "-");
                this.vt.setVal(s, ro);
            }
        } else if (s.equals("{")) {
            this.block();
        } else if (s.equals("++")) {
            Token t = this.ta.getToken(this.index++);
            this.variablePush(t);
            Object ro = Operator.operate(new Integer(1), this.stackVal.pop(), "+");
            this.vt.setVal(t.getVal(), ro);
            this.stackVal.push(ro);
        } else if (s.equals("--")) {
            Token t = this.ta.getToken(this.index++);
            this.variablePush(t);
            Object ro = Operator.operate(new Integer(1), this.stackVal.pop(), "-");
            this.vt.setVal(t.getVal(), ro);
            this.stackVal.push(ro);
        } else if (s.equals("assertEquals")) {
            this.assertEq();
        } else if (s.equals(this.targetName)) {
            this.targetInvoke();
        }
    }

    private void assertEq() {
        this.expression();
        Object o = this.stackVal.pop();
        Class c = (Class)this.stackType.pop();
        if (this.ta.getVal(this.index).equals(this.targetName)) {
            ++this.index;
            String name = this.targetInvoke();
            this.target.addHistory(this.history.toString(), ToStringer.get(o));
            this.target.overWriteMethodReType(name, LangMgn.getClassName(c));
        } else {
            this.expression();
            boolean noChangeStateFlag = "noChangeState".equals((String)o);
            o = this.stackVal.pop();
            c = (Class)this.stackType.pop();
            ++this.index;
            if (this.ta.getVal(this.index++).equals(this.targetName)) {
                String tempHistory = this.history.toString();
                String name = this.targetInvoke();
                this.target.addHistory(this.history.toString(), ToStringer.get(o));
                this.target.overWriteMethodReType(name, LangMgn.getClassName(c));
                if (noChangeStateFlag) {
                    this.target.addNoChange(name);
                    this.history = new StringBuffer(tempHistory);
                }
            }
        }
    }

    private String targetInvoke() {
        Token t = this.ta.getToken(this.index++);
        String name = null;
        if (t.getKind() == 15) {
            name = this.targetMethod();
        } else if (t.getKind() == 5 && this.ta.getVal(this.index).equals("new")) {
            ++this.index;
            name = this.targetMethod();
            this.target.setMethodReType(name, "");
            String className = name.substring(0, name.indexOf(40));
            if (!this.target.getClassName().equals(className)) {
                this.target.setClassName(className);
                Class c = this.cnr.getClazz(this.target.getSuperName());
                this.target.setSuperClass(c);
            }
        }
        return name;
    }

    private String targetMethod() {
        String name = this.ta.getVal(this.index++);
        Object[] o2 = this.arg();
        Object[] os = (Object[])o2[0];
        Class[] cs = (Class[])o2[1];
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        if (cs != null) {
            int i = 0;
            while (i < cs.length) {
                sb.append(cs[i].getName());
                sb.append(" ");
                ++i;
            }
        }
        sb.append(")");
        String methodSign = sb.toString();
        this.target.addMethod(methodSign, "void");
        this.lastCallintTargetMethodName = name;
        this.history.append(methodSign);
        if (os != null) {
            this.history.append("(");
            int i = 0;
            while (i < os.length) {
                this.history.append(ToStringer.get(os[i]));
                this.history.append(" ");
                ++i;
            }
            this.history.append(")");
        }
        this.history.append(";");
        return methodSign;
    }

    protected boolean isVariable(String s) {
        if (LangMgn.isPremit(s)) {
            return true;
        }
        Class c = this.cnr.getClazz(s);
        return c != null;
    }

    public TargetClass getTargetClass() {
        return this.target;
    }

    public TestClass getTestClass() {
        return this.tc;
    }

    protected VariableTable getVariableTable() {
        return this.vt;
    }
}

