/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.NotTestCaseException;
import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.TokenArray;

public class TestAnalyst
implements Analyst {
    private TokenArray ta;
    private TestClass tc;
    private TargetClass target;

    public TestAnalyst(TokenArray inTa) {
        this.ta = inTa;
    }

    public void analyze() throws Exception {
        this.setTestClass();
        this.setTargetClass();
        this.setSetUp();
        this.setTestMethod();
    }

    protected void setSetUp() {
        int start = this.ta.indexOfVal("protected", "void", "setUp");
        if (start != -1) {
            int end = this.getIndexOfClosed(this.ta, start, "{", "}");
            this.tc.setSetUp(this.ta.takeSubArray(start, end + 1));
        }
    }

    protected void setTestMethod() {
        int start = this.getIndexOfTestMethod();
        while (start != -1) {
            int end = this.getIndexOfClosed(this.ta, start, "{", "}");
            this.tc.addTestMethod(this.ta.takeSubArray(start, end + 1));
            start = this.getIndexOfTestMethod();
        }
    }

    private int getIndexOfTestMethod() {
        int start = -1;
        do {
            if ((start = this.ta.indexOfVal("public", "void", start + 1)) == -1 || !this.ta.getVal(start + 2).startsWith("test")) continue;
            return start;
        } while (start != -1);
        return -1;
    }

    private int getIndexOfClosed(TokenArray arr, int start, String op, String cl) {
        int count = 0;
        int i = start;
        while (i < arr.length()) {
            if (arr.getVal(i).equals(op)) {
                ++count;
            } else if (arr.getVal(i).equals(cl) && --count == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setTestClass() throws Exception {
        int index = this.ta.indexOfVal("package");
        int endindex = this.ta.indexOfVal(";", index);
        StringBuffer sb = new StringBuffer();
        int i = index + 1;
        while (i < endindex) {
            sb.append(this.ta.getVal(i));
            ++i;
        }
        String pack = sb.toString();
        Import[] im = this.getImports();
        index = this.ta.indexOfVal("class");
        String name = this.ta.getVal(index + 1);
        index = this.ta.indexOfVal("extends");
        if (this.ta.getVal(index + 1).indexOf("TestCase") == -1) {
            throw new NotTestCaseException("This class is not TestCase : " + name);
        }
        this.tc = new TestClass(pack, name);
        this.tc.setImports(im);
        this.ta = this.ta.takeSubArray(this.ta.indexOfVal("{", index) + 1, this.getIndexOfClosed(this.ta, index, "{", "}"));
    }

    protected Import[] getImports() {
        int num = this.ta.howManyOfVal("import");
        Import[] im = new Import[num];
        int i = 0;
        while (i < im.length) {
            int from = this.ta.indexOfVal("import");
            int end = this.ta.indexOfVal(";", from);
            im[i] = new Import(this.ta.takeSubArray(from, end + 1));
            ++i;
        }
        return im;
    }

    protected void setTargetClass() {
        int index = this.ta.indexOfKind(4);
        while (LangMgn.isReserved(this.ta.getVal(index))) {
            ++index;
        }
        this.target = new TargetClass(this.ta.getVal(index), this.ta.getVal(index + 1));
        this.target.setPack(this.tc.packageName());
        if (this.ta.getVal(index + 2).equals(";")) {
            this.ta = this.ta.takeSubArray(index + 3);
        }
    }

    public TargetClass getTargetClass() {
        return this.target;
    }

    public TestClass getTestClass() {
        return this.tc;
    }
}

