/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.util.AbstractList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.TypeOwner;

public class TypeOwnerTest
extends TestCase {
    TypeOwner to;
    int size;

    protected void setUp() throws Exception {
        super.setUp();
        this.to = new TypeOwner();
        Class[] pushed = this.to.pushedConcreteClasses();
        this.size = pushed.length;
    }

    public void testArray() {
        this.to.push(int[].class);
        TypeOwnerTest.assertEquals((int)1, (int)this.to.size());
        Class[] pushed = this.to.pushedConcreteClasses();
        TypeOwnerTest.assertEquals((int)(this.size + 1), (int)pushed.length);
    }

    public void testPush_Simple() {
        this.to.push(Integer.TYPE);
        this.to.push(StringBuffer.class);
        TypeOwnerTest.assertEquals((int)2, (int)this.to.size());
    }

    public void testPushedConcreteClasses() {
        this.to.push(Integer.class);
        this.to.push(Vector.class);
        Class[] pushed = this.to.pushedConcreteClasses();
        TypeOwnerTest.assertEquals((int)(this.size + 2), (int)pushed.length);
    }

    public void testNotHaveSameClass() {
        this.to.push(String.class);
        this.to.push(String.class);
        Class[] pushed = this.to.pushedConcreteClasses();
        TypeOwnerTest.assertEquals((int)(this.size + 1), (int)pushed.length);
    }

    public void testNotHaveInterface() {
        this.to.push(List.class);
        this.to.push(Character.class);
        Class[] pushed = this.to.pushedConcreteClasses();
        TypeOwnerTest.assertEquals((int)(this.size + 1), (int)pushed.length);
    }

    public void testNotHaveAbstract() {
        this.to.push(AbstractList.class);
        this.to.push(Calendar.class);
        this.to.push(Object.class);
        Class[] pushed = this.to.pushedConcreteClasses();
        TypeOwnerTest.assertEquals((int)(this.size + 1), (int)pushed.length);
    }
}

