/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.runner;

import java.io.File;
import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.Filter;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.runner.Implementer;
import org.kikaineko.mock.runner.KikainekoClassLoaderWrapper;
import org.kikaineko.mock.runner.Runner;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;

public class BaseRunner
implements Runner {
    private File target;

    public void setCustumClassLoader(ClassLoader cl) {
        KikainekoClassLoaderWrapper.setClassLoader(cl);
    }

    public File targetFile() {
        return this.target;
    }

    protected void setLang() {
        LangMgn.setLang(new Java());
    }

    protected StringBuffer overWrite(StringBuffer sb) {
        if (this.target.exists()) {
            sb.append(System.getProperty("line.separator"));
            sb.append(System.getProperty("line.separator"));
            String[] codes = FileIO.getFileDatas(this.target);
            int i = 0;
            while (i < codes.length) {
                sb.append("//");
                sb.append(codes[i]);
                sb.append(System.getProperty("line.separator"));
                ++i;
            }
        }
        return sb;
    }

    protected Analyst analystFactory(Object input) {
        if (input instanceof File) {
            return new TestAnalyst(new CodeReader((File)input).getTokenArrayWithoutComment());
        }
        if (input instanceof TestAnalyst) {
            return new SmallInterpreter(((Analyst)input).getTestClass(), ((Analyst)input).getTargetClass());
        }
        return null;
    }

    protected TargetClass filter(TargetClass tc) {
        return Filter.execute(tc);
    }

    public final StringBuffer doRun(File test) throws Exception {
        this.setLang();
        Analyst preAnalyst = this.analystFactory(test);
        preAnalyst.analyze();
        Analyst interpreter = this.analystFactory(preAnalyst);
        interpreter.analyze();
        TargetClass tc = this.filter(interpreter.getTargetClass());
        Implementer im = new Implementer(tc);
        File parent = test.getParentFile();
        this.target = new File(parent, im.getTargetFile().getName());
        return this.overWrite(new StringBuffer(im.getCode()));
    }
}

