/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.runner;

import junit.framework.TestCase;
import org.kikaineko.mock.runner.ClassFileSeeker;
import org.kikaineko.mock.runner.InvalidPathException;
import org.kikaineko.mock.runner.Path;

public class ClassFileSeekerTest
extends TestCase {
    ClassFileSeeker cfs;

    protected void setUp() throws Exception {
        super.setUp();
        Path[] ps = new Path[]{new Path("C:\\Documents and Settings\\masayuki\\workspace\\kikainekomocker\\Sandbox", 0), new Path("C:\\eclipse\\plugins\\org.junit_3.8.1\\junit.jar", 2), new Path("C:\\Documents and Settings\\masayuki\\workspace\\kikainekomocker\\KikainekoMocker\\bin", 1)};
        this.cfs = new ClassFileSeeker(ps);
    }

    public void test\u3061\u3083\u3093\u3068\u30bd\u30fc\u30c8\u3059\u308b\u304b() {
        Path[] ps = new Path[4];
        try {
            ps[0] = new Path("C:\\eclipse", 99);
            ps[1] = new Path("C:\\eclipse", 1);
            ps[2] = new Path("C:\\eclipse", 2);
            ps[3] = new Path("C:\\eclipse", 0);
        }
        catch (InvalidPathException e) {
            ClassFileSeekerTest.fail();
        }
        this.cfs = new ClassFileSeeker(ps);
        ClassFileSeekerTest.assertEquals((int)0, (int)this.cfs.getPath(0).getType());
        ClassFileSeekerTest.assertEquals((int)1, (int)this.cfs.getPath(1).getType());
        ClassFileSeekerTest.assertEquals((int)2, (int)this.cfs.getPath(2).getType());
        ClassFileSeekerTest.assertEquals((int)99, (int)this.cfs.getPath(3).getType());
    }

    public void test\u81ea\u5206\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306e\u30d0\u30a4\u30ca\u30ea\u3092\u898b\u3064\u3051\u3066\u304f\u308b() {
        byte[] bs = this.cfs.findBytes("sandbox.Aaaa");
        ClassFileSeekerTest.assertNotNull((Object)bs);
    }

    public void testJar\u304b\u3089\u3082\u3061\u3083\u3093\u3068\u307f\u3064\u3051\u308b\u3088\u306d() {
        byte[] bs = this.cfs.findBytes("junit.framework.TestCase");
        ClassFileSeekerTest.assertNotNull((Object)bs);
    }

    public void test\u307b\u304b\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u304b\u3089\u3082\u3061\u3083\u3093\u3068\u307f\u3064\u3051\u308b\u3088\u306d() {
        byte[] bs = this.cfs.findBytes("temp.Calc");
        ClassFileSeekerTest.assertNotNull((Object)bs);
    }
}

