/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.util;

import junit.framework.TestCase;
import org.kikaineko.mock.util.ArgToken;
import org.kikaineko.mock.util.ToStringer;

public class ArgTokenTest
extends TestCase {
    ArgToken at;

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNULL() {
        this.at = new ArgToken("@0");
        Object[] os = this.at.gets();
        ArgTokenTest.assertEquals((int)1, (int)os.length);
        ArgTokenTest.assertEquals(null, (Object)os[0]);
    }

    public void testKara() {
        this.at = new ArgToken("");
        Object[] os = this.at.gets();
        ArgTokenTest.assertEquals((int)0, (int)os.length);
    }

    public void testNext() {
        this.at = new ArgToken("a b c ");
        ArgTokenTest.assertEquals((String)"a", (String)this.at.token());
        ArgTokenTest.assertEquals((String)"b", (String)this.at.token());
        ArgTokenTest.assertEquals((boolean)true, (boolean)this.at.hasMore());
        ArgTokenTest.assertEquals((String)"c", (String)this.at.token());
        ArgTokenTest.assertEquals((boolean)false, (boolean)this.at.hasMore());
    }

    public void testToStringer() {
        int[] is = new int[]{1, 2};
        this.at = new ArgToken(ToStringer.get(is));
        Object[] os = this.at.gets();
        ArgTokenTest.assertEquals((int)1, (int)os.length);
        Object[] os1 = (Object[])os[0];
        ArgTokenTest.assertEquals((Object)"1", (Object)os1[0]);
        ArgTokenTest.assertEquals((Object)"2", (Object)os1[1]);
        String[][] ss = new String[][]{{"10", "20"}, {"11", "22"}};
        this.at = new ArgToken(ToStringer.get(ss));
        os = this.at.gets();
        ArgTokenTest.assertEquals((int)1, (int)os.length);
        os1 = (Object[])os[0];
        ArgTokenTest.assertEquals((int)2, (int)os1.length);
        Object[] os2_1 = (Object[])os1[0];
        Object[] os2_2 = (Object[])os1[1];
        ArgTokenTest.assertEquals((int)2, (int)os2_1.length);
        ArgTokenTest.assertEquals((int)2, (int)os2_2.length);
        ArgTokenTest.assertEquals((Object)"10", (Object)os2_1[0]);
        ArgTokenTest.assertEquals((Object)"20", (Object)os2_1[1]);
        ArgTokenTest.assertEquals((Object)"11", (Object)os2_2[0]);
        ArgTokenTest.assertEquals((Object)"22", (Object)os2_2[1]);
    }

    public void testNextWithAT() {
        this.at = new ArgToken("a@ b cc ");
        ArgTokenTest.assertEquals((String)"a b", (String)this.at.token());
        ArgTokenTest.assertEquals((String)"cc", (String)this.at.token());
        this.at = new ArgToken("@ a@@b cc ");
        ArgTokenTest.assertEquals((String)" a@b", (String)this.at.token());
        ArgTokenTest.assertEquals((String)"cc", (String)this.at.token());
    }

    public void testGets() {
        Object[] ss = new ArgToken("a@ b cc @@ ").gets();
        ArgTokenTest.assertEquals((int)3, (int)ss.length);
        ArgTokenTest.assertEquals((Object)"a b", (Object)ss[0]);
        ArgTokenTest.assertEquals((Object)"cc", (Object)ss[1]);
        ArgTokenTest.assertEquals((Object)"@", (Object)ss[2]);
        ss = new ArgToken("aa ").gets();
        ArgTokenTest.assertEquals((int)1, (int)ss.length);
        ArgTokenTest.assertEquals((Object)"aa", (Object)ss[0]);
        ss = new ArgToken("aa @[").gets();
        ArgTokenTest.assertEquals((int)2, (int)ss.length);
        ArgTokenTest.assertEquals((Object)"aa", (Object)ss[0]);
        ArgTokenTest.assertEquals((Object)"[", (Object)ss[1]);
    }

    public void testArray() {
        Object[] os = new ArgToken("[a 1 2c ]").gets();
        ArgTokenTest.assertEquals((int)1, (int)os.length);
        Object[] ss = (Object[])os[0];
        ArgTokenTest.assertEquals((int)3, (int)ss.length);
        ArgTokenTest.assertEquals((Object)"a", (Object)ss[0]);
        ArgTokenTest.assertEquals((Object)"1", (Object)ss[1]);
        ArgTokenTest.assertEquals((Object)"2c", (Object)ss[2]);
        os = new ArgToken("[a 1 2c ] ooo 1@ fd ").gets();
        ArgTokenTest.assertEquals((int)3, (int)os.length);
        ArgTokenTest.assertEquals((Object)"ooo", (Object)os[1]);
        ArgTokenTest.assertEquals((Object)"1 fd", (Object)os[2]);
    }

    public void testArrayDouble() {
        Object[] os = new ArgToken("[1 2 ] [3 4 5 6 ]").gets();
        ArgTokenTest.assertEquals((int)2, (int)os.length);
        Object[] ss1 = (Object[])os[0];
        ArgTokenTest.assertEquals((int)2, (int)ss1.length);
        ArgTokenTest.assertEquals((Object)"1", (Object)ss1[0]);
        ArgTokenTest.assertEquals((Object)"2", (Object)ss1[1]);
        Object[] ss2 = (Object[])os[1];
        ArgTokenTest.assertEquals((int)4, (int)ss2.length);
        ArgTokenTest.assertEquals((Object)"3", (Object)ss2[0]);
        ArgTokenTest.assertEquals((Object)"4", (Object)ss2[1]);
        ArgTokenTest.assertEquals((Object)"5", (Object)ss2[2]);
        ArgTokenTest.assertEquals((Object)"6", (Object)ss2[3]);
    }

    public void testArray2Dim() {
        Object[] bottom = new ArgToken("[[1 2 ] [3 4 5 6 ] ]").gets();
        ArgTokenTest.assertEquals((int)1, (int)bottom.length);
        Object[] level1 = (Object[])bottom[0];
        ArgTokenTest.assertEquals((int)2, (int)level1.length);
        Object[] level2_1 = (Object[])level1[0];
        ArgTokenTest.assertEquals((int)2, (int)level2_1.length);
        ArgTokenTest.assertEquals((Object)"1", (Object)level2_1[0]);
        ArgTokenTest.assertEquals((Object)"2", (Object)level2_1[1]);
        Object[] level2_2 = (Object[])level1[1];
        ArgTokenTest.assertEquals((int)4, (int)level2_2.length);
        ArgTokenTest.assertEquals((Object)"3", (Object)level2_2[0]);
        ArgTokenTest.assertEquals((Object)"4", (Object)level2_2[1]);
        ArgTokenTest.assertEquals((Object)"5", (Object)level2_2[2]);
        ArgTokenTest.assertEquals((Object)"6", (Object)level2_2[3]);
    }

    public void testArray3Dim() {
        Object[] bottom = new ArgToken("[[[111 112 ] [121 122 ] ] [[211 212 ] [221 222 ] ] ]").gets();
        ArgTokenTest.assertEquals((int)1, (int)bottom.length);
        Object[] level1 = (Object[])bottom[0];
        ArgTokenTest.assertEquals((int)2, (int)level1.length);
        Object[] level2_1 = (Object[])level1[0];
        ArgTokenTest.assertEquals((int)2, (int)level2_1.length);
        Object[] level3_1 = (Object[])level2_1[0];
        ArgTokenTest.assertEquals((int)2, (int)level3_1.length);
        ArgTokenTest.assertEquals((Object)"111", (Object)level3_1[0]);
        ArgTokenTest.assertEquals((Object)"112", (Object)level3_1[1]);
        Object[] level3_2 = (Object[])level2_1[1];
        ArgTokenTest.assertEquals((int)2, (int)level3_2.length);
        ArgTokenTest.assertEquals((Object)"121", (Object)level3_2[0]);
        ArgTokenTest.assertEquals((Object)"122", (Object)level3_2[1]);
        Object[] level2_2 = (Object[])level1[1];
        ArgTokenTest.assertEquals((int)2, (int)level2_2.length);
        Object[] level3_3 = (Object[])level2_2[1];
        ArgTokenTest.assertEquals((int)2, (int)level3_3.length);
        ArgTokenTest.assertEquals((Object)"221", (Object)level3_3[0]);
        ArgTokenTest.assertEquals((Object)"222", (Object)level3_3[1]);
    }
}

