/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.kikaineko.mock.util.FieldSorter;
import org.kikaineko.mock.util.KikainekoChar;
import org.kikaineko.mock.util.ObjectCreater;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.Tokenizer;

public class ReturnValue {
    private static String kakkoTrim(String s) {
        return s.substring(s.indexOf("(") + 1, s.length() - 1);
    }

    public static int intValue(String s) {
        return Integer.parseInt(ReturnValue.kakkoTrim(s));
    }

    public static long longValue(String string) {
        return Long.parseLong(ReturnValue.kakkoTrim(string));
    }

    public static float floatValue(String string) {
        return Float.parseFloat(ReturnValue.kakkoTrim(string));
    }

    public static double doubleValue(String string) {
        return Double.parseDouble(ReturnValue.kakkoTrim(string));
    }

    public static char charValue(String string) {
        return (char)Integer.parseInt(ReturnValue.kakkoTrim(string));
    }

    public static String stringValue(String string) {
        return ReturnValue.kakkoTrim(string);
    }

    public static Class getClass(String val) {
        Class<?> c = LangMgn.getPremitClass(val);
        if (c != null) {
            return c;
        }
        try {
            c = Class.forName(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    protected static Object getRupperObject(String clazz, String val) {
        if (clazz.equals("int") || clazz.equals("Integer")) {
            return new Integer(val);
        }
        if (clazz.equals("long") || clazz.equals("Long")) {
            return new Long(val);
        }
        if (clazz.equals("float") || clazz.equals("Float")) {
            return new Float(val);
        }
        if (clazz.equals("double") || clazz.equals("Double")) {
            return new Double(val);
        }
        if (clazz.equals("char") || clazz.equals("Character")) {
            char c = (char)Integer.parseInt(val);
            return new Character(c);
        }
        if (clazz.equals("java.lang.String")) {
            return ReturnValue.sanit(val);
        }
        if (clazz.equals("boolean") || clazz.equals("Boolean")) {
            return new Boolean(val);
        }
        if (clazz.equals("Class")) {
            return ReturnValue.getClass(val);
        }
        return null;
    }

    private static String sanit(String value) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < value.length()) {
            char c = value.charAt(index);
            if (c == '@') {
                c = value.charAt(index + 1);
                sb.append(c);
                ++index;
            } else {
                sb.append(c);
            }
            ++index;
        }
        return sb.toString();
    }

    protected static Object getArray(Class clazz, String val) {
        Class uc = LangMgn.underOneDimentionArray(clazz);
        String[] ss = ReturnValue.getSameLevelStrings(val);
        Object os = Array.newInstance(uc, ss.length);
        try {
            int i = 0;
            while (i < ss.length) {
                if (ss[i].getClass().isArray()) {
                    Array.set(os, i, ReturnValue.getArray(uc, ss[i]));
                } else {
                    Array.set(os, i, ReturnValue.getObject(ss[i].toString()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return os;
    }

    public static Object getObject(String value) {
        return ReturnValue.getObject(value, null);
    }

    public static Object getObject(String value, Class[] usedClasses) {
        if (value == null) {
            return null;
        }
        String[] \u578b\u3068\u5024 = ReturnValue.getTypeAndValue(value);
        String \u578b = \u578b\u3068\u5024[0];
        String \u5024 = \u578b\u3068\u5024[1];
        if (\u5024.equals(KikainekoChar.NULL)) {
            return null;
        }
        try {
            Object o = ReturnValue.getRupperObject(\u578b, \u5024);
            if (o != null) {
                return o;
            }
            Class<?> c = Class.forName(\u578b);
            if (\u578b.startsWith("[")) {
                return ReturnValue.getArray(c, \u5024);
            }
            o = ObjectCreater.newInstance(c, usedClasses);
            String[] ss = ReturnValue.getSameLevelStrings(\u5024);
            AccessibleObject[] fs = FieldSorter.sortWithOutFinalStaticTrans(o);
            AccessibleObject.setAccessible(fs, true);
            int i = 0;
            while (i < ss.length) {
                if (!Modifier.isFinal(((Field)fs[i]).getModifiers())) {
                    ((Field)fs[i]).set(o, ReturnValue.getObject(ss[i]));
                }
                ++i;
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean booleanValue(String string) {
        return ReturnValue.kakkoTrim(string).startsWith("true");
    }

    public static byte byteValue(String string) {
        return Byte.parseByte(ReturnValue.kakkoTrim(string));
    }

    public static short shortValue(String string) {
        return Short.parseShort(ReturnValue.kakkoTrim(string));
    }

    protected static String[] getTypeAndValue(String s) {
        String[] ss = new String[2];
        int \u306f\u3058\u3081\u306e\u304b\u3063\u3053\u306e\u4f4d\u7f6e = s.indexOf("(");
        ss[0] = s.substring(0, \u306f\u3058\u3081\u306e\u304b\u3063\u3053\u306e\u4f4d\u7f6e);
        String \u304b\u3063\u3053\u306f\u305a\u3059\u307e\u3048\u306e\u5024 = s.substring(\u306f\u3058\u3081\u306e\u304b\u3063\u3053\u306e\u4f4d\u7f6e);
        int \u6700\u5f8c\u306e\u304b\u3063\u3053\u306e\u4f4d\u7f6e = \u304b\u3063\u3053\u306f\u305a\u3059\u307e\u3048\u306e\u5024.lastIndexOf(")");
        ss[1] = \u304b\u3063\u3053\u306f\u305a\u3059\u307e\u3048\u306e\u5024.substring(1, \u6700\u5f8c\u306e\u304b\u3063\u3053\u306e\u4f4d\u7f6e);
        return ss;
    }

    protected static String[] getSameLevelStrings(String s) {
        String \u304b\u3063\u3053 = String.valueOf('(');
        String \u304b\u3063\u3053\u9589\u3058 = String.valueOf(')');
        String \u30cc\u30eb\u8868\u73fe = KikainekoChar.NULL;
        Vector motoneta = ReturnValue.get\u304b\u3063\u3053\u3068\u30cc\u30eb\u8868\u73fe\u3068\u305d\u308c\u4ee5\u5916\u306b\u5206\u5272\u3057\u305f\u6587\u5b57\u5217\u306e\u914d\u5217(s);
        int lev = 0;
        Vector<String> vec = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < motoneta.size()) {
            String str = (String)motoneta.get(index);
            if (str.equals(\u304b\u3063\u3053\u9589\u3058)) {
                --lev;
                sb.append(str);
            } else if (str.equals(\u30cc\u30eb\u8868\u73fe)) {
                sb.append(str);
            } else {
                sb.append(str);
                if (motoneta.get(index + 1).equals(\u304b\u3063\u3053)) {
                    sb.append(\u304b\u3063\u3053);
                    ++lev;
                    ++index;
                } else {
                    sb.append(\u304b\u3063\u3053\u9589\u3058);
                    --lev;
                    ++index;
                }
            }
            if (lev == 0) {
                vec.add(sb.toString());
                sb = new StringBuffer();
            }
            ++index;
        }
        String[] ss = new String[vec.size()];
        int i = 0;
        while (i < ss.length) {
            ss[i] = (String)vec.get(i);
            ++i;
        }
        return ss;
    }

    protected static Vector get\u304b\u3063\u3053\u3068\u30cc\u30eb\u8868\u73fe\u3068\u305d\u308c\u4ee5\u5916\u306b\u5206\u5272\u3057\u305f\u6587\u5b57\u5217\u306e\u914d\u5217(String s) {
        String \u304b\u3063\u3053 = String.valueOf('(');
        String \u304b\u3063\u3053\u9589\u3058 = String.valueOf(')');
        String \u30a8\u30b9\u30b1\u30fc\u30d7 = String.valueOf('@');
        String \u30cc\u30eb\u6587\u5b57 = String.valueOf('0');
        Vector<String> v = new Vector<String>();
        Tokenizer t = new Tokenizer(s);
        Token[] tks = t.getTokens();
        StringBuffer sb = new StringBuffer();
        boolean \u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u308b = false;
        int i = 0;
        while (i < tks.length) {
            String str = tks[i].getVal();
            if (!\u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u308b) {
                if (str.equals(\u304b\u3063\u3053)) {
                    v.add(sb.toString());
                    v.add(\u304b\u3063\u3053);
                    sb = new StringBuffer();
                } else if (str.equals(\u304b\u3063\u3053\u9589\u3058)) {
                    if (sb.length() > 0) {
                        v.add(sb.toString());
                    }
                    v.add(\u304b\u3063\u3053\u9589\u3058);
                    sb = new StringBuffer();
                } else {
                    sb.append(str);
                    if (str.equals(\u30a8\u30b9\u30b1\u30fc\u30d7)) {
                        \u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u308b = true;
                    }
                }
            } else {
                sb.append(str);
                if (str.equals(\u30cc\u30eb\u6587\u5b57)) {
                    v.add(sb.toString());
                    sb = new StringBuffer();
                }
                \u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u308b = false;
            }
            ++i;
        }
        return v;
    }
}

