/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.util;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import junit.framework.TestCase;
import org.kikaineko.mock.util.ReturnValue;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.Token;
import temp.Foo;
import temp.FooImpl;
import temp.FooUser;
import temp.TokenChild;

public class ReturnValueTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBufferedWriter\u306f\u5185\u90e8\u3067\u5faa\u74b0\u53c2\u7167\u3092\u6301\u3063\u3066\u3044\u308b\u304c\u305d\u308c\u304c\u7121\u9650\u30eb\u30fc\u30d7\u306b\u843d\u3061\u305a\u898b\u4e8b\u518d\u751f\u3067\u304d\u308b\u304b() {
        BufferedWriter b = new BufferedWriter(new OutputStreamWriter(System.out));
        String s = ToStringer.get(b);
        BufferedWriter b1 = (BufferedWriter)ReturnValue.getObject(s);
        ReturnValueTest.assertNotNull((Object)b1);
    }

    public void test\u7d99\u627f\u3057\u305f\u3084\u3064\u3082\u554f\u984c\u306a\u3044\u304b() {
        TokenChild tc = new TokenChild(1);
        tc.setKind(99);
        String s = ToStringer.get(tc);
        TokenChild tc2 = (TokenChild)ReturnValue.getObject(s);
        ReturnValueTest.assertEquals((String)tc.getVal(), (String)tc2.getVal());
        ReturnValueTest.assertEquals((int)tc.getI(), (int)tc2.getI());
        ReturnValueTest.assertEquals((int)tc.getKind(), (int)tc2.getKind());
    }

    public void test\u30cc\u30eb\u95a2\u4fc2\u3092\u30c1\u30a7\u30c3\u30af() {
        String s = "";
        String s2 = (String)ReturnValue.getObject(ToStringer.get(s));
        ReturnValueTest.assertEquals((String)s, (String)s2);
        s = null;
        s2 = (String)ReturnValue.getObject(ToStringer.get(s));
        ReturnValueTest.assertEquals((String)s, (String)s2);
        int i = 0;
        int j = ReturnValue.intValue(ToStringer.get(i));
        ReturnValueTest.assertEquals((int)i, (int)j);
        i = -1;
        j = ReturnValue.intValue(ToStringer.get(i));
        ReturnValueTest.assertEquals((int)i, (int)j);
    }

    public void test\u30a8\u30b9\u30b1\u30fc\u30d7\u95a2\u4fc2\u3092\u30c1\u30a7\u30c3\u30af\u3059\u308b() {
        String s = "\\";
        String s2 = (String)ReturnValue.getObject(ToStringer.get(s));
        ReturnValueTest.assertEquals((String)s, (String)s2);
        s = "@0";
        s2 = (String)ReturnValue.getObject(ToStringer.get(s));
        ReturnValueTest.assertEquals((String)s, (String)s2);
        s = "@@@/@@@@@000\\@ @@\\@@  ";
        s2 = (String)ReturnValue.getObject(ToStringer.get(s));
        ReturnValueTest.assertEquals((String)s, (String)s2);
        s = "./*\\[]-+<>;:\"'%&(){}!#,@^~| ";
        s2 = (String)ReturnValue.getObject(ToStringer.get(s));
        ReturnValueTest.assertEquals((String)s, (String)s2);
    }

    public void testVector() {
        Vector<String> vec = new Vector<String>();
        vec.add("\u6a5f\u68b0\u732b");
        vec.add("\u30c9\u30e9\u3048\u3082\u3093");
        String s = ToStringer.get(vec);
        Vector vec2 = (Vector)ReturnValue.getObject(s);
        ReturnValueTest.assertEquals((String)"\u6a5f\u68b0\u732b", (String)((String)vec2.get(0)));
        ReturnValueTest.assertEquals((String)"\u30c9\u30e9\u3048\u3082\u3093", (String)((String)vec2.get(1)));
    }

    public void testToken() {
        Token t1 = new Token(1, "2");
        Token t2 = (Token)ReturnValue.getObject("org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))");
        ReturnValueTest.assertEquals((String)t1.getVal(), (String)t2.getVal());
    }

    public void testObject() {
        Token t = new Token(1, "1");
        Token t2 = (Token)ReturnValue.getObject(ToStringer.get(t));
        ReturnValueTest.assertEquals((String)t.getVal(), (String)t2.getVal());
        ReturnValueTest.assertEquals((int)t.getKind(), (int)t2.getKind());
        Integer i1 = new Integer(1);
        Integer i2 = (Integer)ReturnValue.getObject(ToStringer.get(i1));
        ReturnValueTest.assertEquals((Object)i1, (Object)i2);
        StringBuffer sb1 = new StringBuffer("hoge");
        StringBuffer sb2 = (StringBuffer)ReturnValue.getObject(ToStringer.get(sb1));
        ReturnValueTest.assertEquals((String)sb1.toString(), (String)sb2.toString());
    }

    public void test\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306b\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u304c\u5fc5\u8981\u305d\u3046\u306a\u3082\u306e\u3082\u751f\u6210\u3067\u304d\u308b\u304b() {
        FooImpl foo = new FooImpl();
        FooUser foouser = new FooUser((Foo)foo);
        Class[] cs = new Class[]{FooImpl.class};
        FooUser f2 = (FooUser)ReturnValue.getObject(ToStringer.get(foouser), cs);
        ReturnValueTest.assertNotNull((Object)f2);
        Calendar cal = Calendar.getInstance();
        Class[] cs2 = new Class[]{GregorianCalendar.class};
        Calendar cal2 = (Calendar)ReturnValue.getObject(ToStringer.get(cal), cs2);
        ReturnValueTest.assertNotNull((Object)cal2);
    }

    public void testArray() {
        String[] ss = new String[]{"\u3042\u307b", "()"};
        String s = ToStringer.get(ss);
        String[] ss2 = (String[])ReturnValue.getObject(s);
        ReturnValueTest.assertEquals((int)ss.length, (int)ss2.length);
        ReturnValueTest.assertEquals((String)ss[0], (String)ss2[0]);
        ReturnValueTest.assertEquals((String)ss[1], (String)ss2[1]);
    }

    public void test\u540c\u3058\u30ec\u30d9\u30eb\u306e\u3084\u3064\u3092\u5206\u5272() {
        String s = "aho()";
        String[] ss = ReturnValue.getSameLevelStrings(s);
        ReturnValueTest.assertEquals((String)"aho()", (String)ss[0]);
        s = "aho(boke()nasu())";
        ss = ReturnValue.getSameLevelStrings(s);
        ReturnValueTest.assertEquals((String)"aho(boke()nasu())", (String)ss[0]);
        s = "org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))";
        ss = ReturnValue.getSameLevelStrings(s);
        ReturnValueTest.assertEquals((int)1, (int)ss.length);
        s = "boolean(false)int(1)java.lang.String(2)";
        ss = ReturnValue.getSameLevelStrings(s);
        ReturnValueTest.assertEquals((String)"boolean(false)", (String)ss[0]);
        ReturnValueTest.assertEquals((String)"int(1)", (String)ss[1]);
        ReturnValueTest.assertEquals((String)"java.lang.String(2)", (String)ss[2]);
    }

    public void test\u6587\u5b57\u5217\u3092\u30ab\u30c3\u30b3\u3068\u305d\u308c\u4ee5\u5916\u306b\u5206\u5272\u3059\u308b() {
        String s = "org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))";
        Vector ss = ReturnValue.get\u304b\u3063\u3053\u3068\u30cc\u30eb\u8868\u73fe\u3068\u305d\u308c\u4ee5\u5916\u306b\u5206\u5272\u3057\u305f\u6587\u5b57\u5217\u306e\u914d\u5217(s);
        ReturnValueTest.assertEquals((Object)"org.kikaineko.source.util.Token", ss.get(0));
        ReturnValueTest.assertEquals((Object)"(", ss.get(1));
        ReturnValueTest.assertEquals((Object)"boolean", ss.get(2));
        ReturnValueTest.assertEquals((Object)"(", ss.get(3));
        ReturnValueTest.assertEquals((Object)"false", ss.get(4));
        ReturnValueTest.assertEquals((Object)")", ss.get(5));
        ReturnValueTest.assertEquals((Object)"int", ss.get(6));
        ReturnValueTest.assertEquals((Object)"(", ss.get(7));
        ReturnValueTest.assertEquals((Object)"1", ss.get(8));
        ReturnValueTest.assertEquals((Object)")", ss.get(9));
        ReturnValueTest.assertEquals((Object)"java.lang.String", ss.get(10));
        ReturnValueTest.assertEquals((Object)"(", ss.get(11));
        ReturnValueTest.assertEquals((Object)"2", ss.get(12));
        ReturnValueTest.assertEquals((Object)")", ss.get(13));
        ReturnValueTest.assertEquals((Object)")", ss.get(14));
        s = "aho(String(@())";
        ss = ReturnValue.get\u304b\u3063\u3053\u3068\u30cc\u30eb\u8868\u73fe\u3068\u305d\u308c\u4ee5\u5916\u306b\u5206\u5272\u3057\u305f\u6587\u5b57\u5217\u306e\u914d\u5217(s);
        ReturnValueTest.assertEquals((Object)"aho", ss.get(0));
        ReturnValueTest.assertEquals((Object)"(", ss.get(1));
        ReturnValueTest.assertEquals((Object)"String", ss.get(2));
        ReturnValueTest.assertEquals((Object)"(", ss.get(3));
        ReturnValueTest.assertEquals((Object)"@(", ss.get(4));
        ReturnValueTest.assertEquals((Object)")", ss.get(5));
        ReturnValueTest.assertEquals((Object)")", ss.get(6));
        s = "aho([String(@0@0))";
        ss = ReturnValue.get\u304b\u3063\u3053\u3068\u30cc\u30eb\u8868\u73fe\u3068\u305d\u308c\u4ee5\u5916\u306b\u5206\u5272\u3057\u305f\u6587\u5b57\u5217\u306e\u914d\u5217(s);
        ReturnValueTest.assertEquals((Object)"aho", ss.get(0));
        ReturnValueTest.assertEquals((Object)"(", ss.get(1));
        ReturnValueTest.assertEquals((Object)"[String", ss.get(2));
        ReturnValueTest.assertEquals((Object)"(", ss.get(3));
        ReturnValueTest.assertEquals((Object)"@0", ss.get(4));
        ReturnValueTest.assertEquals((Object)"@0", ss.get(5));
        ReturnValueTest.assertEquals((Object)")", ss.get(6));
        ReturnValueTest.assertEquals((Object)")", ss.get(7));
    }

    public void testGetTypeAndValue() {
        String s = "org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))";
        String[] ss = ReturnValue.getTypeAndValue(s);
        ReturnValueTest.assertEquals((String)"org.kikaineko.source.util.Token", (String)ss[0]);
        ReturnValueTest.assertEquals((String)"boolean(false)int(1)java.lang.String(2)", (String)ss[1]);
    }

    public void testGetTypeAndValue\u306b\u7a7a\u6587\u5b57\u306e\u5974\u3092\u3044\u308c\u3066\u307f\u308b() {
        String s = "java.lang.String()";
        String[] ss = ReturnValue.getTypeAndValue(s);
        ReturnValueTest.assertEquals((String)"java.lang.String", (String)ss[0]);
        ReturnValueTest.assertEquals((String)"", (String)ss[1]);
    }

    public void testString() {
        ReturnValueTest.assertEquals((String)"aho", (String)ReturnValue.stringValue(ToStringer.get("aho")));
    }

    public void testPrimit() {
        String s = ToStringer.get(101);
        ReturnValueTest.assertEquals((int)101, (int)ReturnValue.intValue(s));
        ReturnValueTest.assertEquals((char)'c', (char)ReturnValue.charValue(ToStringer.get('c')));
        ReturnValueTest.assertEquals((long)10L, (long)ReturnValue.longValue(ToStringer.get(10L)));
        ReturnValueTest.assertEquals((float)1.0f, (float)ReturnValue.floatValue(ToStringer.get(1.0f)), (float)0.0f);
        ReturnValueTest.assertEquals((double)1.0, (double)ReturnValue.doubleValue(ToStringer.get(1.0)), (double)0.0);
        ReturnValueTest.assertEquals((byte)1, (byte)ReturnValue.byteValue(ToStringer.get((byte)1)));
        ReturnValueTest.assertEquals((short)1, (short)ReturnValue.shortValue(ToStringer.get((short)1)));
        ReturnValueTest.assertEquals((boolean)false, (boolean)ReturnValue.booleanValue(ToStringer.get(false)));
        ReturnValueTest.assertEquals((boolean)true, (boolean)ReturnValue.booleanValue(ToStringer.get(true)));
    }
}

