/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.source.util;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.List;
import junit.framework.TestCase;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;

public class LangMgnTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        LangMgnTest.assertEquals(Java.class, LangMgn.getLang().getClass());
        LangMgn.setLang(new Java());
    }

    public void testGetAbstractMethods() {
        Method[] ms = LangMgn.getAbstratcMethods(String.class);
        LangMgnTest.assertEquals((int)0, (int)ms.length);
        ms = LangMgn.getAbstratcMethods(AbstractList.class);
        LangMgnTest.assertEquals((int)1, (int)ms.length);
        System.out.println(ms[0].getName());
    }

    public void testGetClassName() {
        LangMgnTest.assertEquals((String)"int", (String)LangMgn.getClassName(Integer.TYPE));
        LangMgnTest.assertEquals((String)"int[]", (String)LangMgn.getClassName(int[].class));
    }

    public void testIsConcreteArray() {
        LangMgnTest.assertEquals((boolean)true, (boolean)LangMgn.isConcrete(int[].class));
        LangMgnTest.assertEquals((boolean)true, (boolean)LangMgn.isConcrete(StringBuffer[][].class));
        LangMgnTest.assertEquals((boolean)false, (boolean)LangMgn.isConcrete(List[].class));
    }

    public void testIsConst() {
        LangMgnTest.assertEquals((boolean)true, (boolean)LangMgn.isConcrete(String.class));
        LangMgnTest.assertEquals((boolean)true, (boolean)LangMgn.isConcrete(Integer.TYPE));
        LangMgnTest.assertEquals((boolean)false, (boolean)LangMgn.isConcrete(AbstractList.class));
    }

    public void testUnitInArray() {
        LangMgnTest.assertEquals(Integer.TYPE, (Object)LangMgn.unitTypeInArray(int[].class));
        LangMgnTest.assertEquals(Double.TYPE, (Object)LangMgn.unitTypeInArray(double[].class));
        LangMgnTest.assertEquals(String.class, (Object)LangMgn.unitTypeInArray(String[].class));
        LangMgnTest.assertEquals(StringBuffer.class, (Object)LangMgn.unitTypeInArray(StringBuffer[].class));
        LangMgnTest.assertEquals(Integer.TYPE, (Object)LangMgn.unitTypeInArray(int[][].class));
    }

    public void testUnderOneDimentionArray() {
        LangMgnTest.assertNull((Object)LangMgn.underOneDimentionArray(Integer.TYPE));
        LangMgnTest.assertEquals(Integer.TYPE, (Object)LangMgn.underOneDimentionArray(int[].class));
        LangMgnTest.assertEquals(int[].class, (Object)LangMgn.underOneDimentionArray(int[][].class));
        LangMgnTest.assertEquals(int[][].class, (Object)LangMgn.underOneDimentionArray(int[][][].class));
        LangMgnTest.assertEquals(StringBuffer[][].class, (Object)LangMgn.underOneDimentionArray(StringBuffer[][][].class));
        LangMgnTest.assertEquals(String[].class, (Object)LangMgn.underOneDimentionArray(String[][].class));
    }

    public void testSuffix() {
        LangMgnTest.assertEquals((String)".java", (String)LangMgn.getSuffix());
        LangMgnTest.assertEquals((String)".class", (String)LangMgn.getBinSuffix());
    }

    public void testArrayType() {
        LangMgnTest.assertEquals((String)"int[]", (String)LangMgn.arrayType(int[].class.getName()));
        LangMgnTest.assertEquals((String)"float[]", (String)LangMgn.arrayType(float[].class.getName()));
        LangMgnTest.assertEquals((String)"long[]", (String)LangMgn.arrayType(long[].class.getName()));
        LangMgnTest.assertEquals((String)"double[]", (String)LangMgn.arrayType(double[].class.getName()));
        LangMgnTest.assertEquals((String)"char[]", (String)LangMgn.arrayType(char[].class.getName()));
        LangMgnTest.assertEquals((String)"byte[]", (String)LangMgn.arrayType(byte[].class.getName()));
        LangMgnTest.assertEquals((String)"short[]", (String)LangMgn.arrayType(short[].class.getName()));
        LangMgnTest.assertEquals((String)"boolean[]", (String)LangMgn.arrayType(boolean[].class.getName()));
        LangMgnTest.assertEquals((String)"java.lang.String[]", (String)LangMgn.arrayType(String[].class.getName()));
        LangMgnTest.assertEquals((String)"java.util.List[]", (String)LangMgn.arrayType(List[].class.getName()));
        LangMgnTest.assertEquals((String)"int[]", (String)LangMgn.arrayType("[I"));
        LangMgnTest.assertEquals((String)"float[]", (String)LangMgn.arrayType("[F"));
        LangMgnTest.assertEquals((String)"long[]", (String)LangMgn.arrayType("[J"));
        LangMgnTest.assertEquals((String)"double[]", (String)LangMgn.arrayType("[D"));
        LangMgnTest.assertEquals((String)"char[]", (String)LangMgn.arrayType("[C"));
        LangMgnTest.assertEquals((String)"byte[]", (String)LangMgn.arrayType("[B"));
        LangMgnTest.assertEquals((String)"short[]", (String)LangMgn.arrayType("[S"));
        LangMgnTest.assertEquals((String)"boolean[]", (String)LangMgn.arrayType("[Z"));
        LangMgnTest.assertEquals((String)"java.lang.String[]", (String)LangMgn.arrayType("[Ljava.lang.String;"));
    }

    public void testTAJUUArray() {
        LangMgnTest.assertEquals((String)"int[][][]", (String)LangMgn.arrayType("[[[I"));
    }

    public void testGetPackagerSeparator() {
        LangMgnTest.assertEquals((String)".", (String)LangMgn.getPackagerSeparator());
    }
}

