/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.sourcescan;

import java.util.StringTokenizer;
import java.util.Vector;
import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.TokenAutomaton;

public class Tokenizer {
    private StringTokenizer ss;
    private String st;
    private int index;
    private TokenAutomaton tokenAutomaton;
    private char lastchar = '\u0000';
    private boolean isMojiretu = false;
    private boolean hasMore = true;
    private Token[] tk;

    public Tokenizer(String string) {
        this.st = string;
        this.index = 0;
        this.tokenAutomaton = new TokenAutomaton();
        if (this.st.length() == 0) {
            this.hasMore = true;
        }
        this.makeTokens();
        this.index = 0;
    }

    protected Token nextToken() {
        return this.tk[this.index++];
    }

    protected Token innerNextToken() {
        StringBuffer sb = new StringBuffer();
        if (this.lastchar != '\u0000') {
            sb.append(this.lastchar);
        }
        int i = this.index;
        while (i < this.st.length()) {
            char c = this.st.charAt(i);
            boolean flag = this.tokenAutomaton.isToken(c);
            if (flag) {
                this.lastchar = c;
                this.index = i + 1;
                return new Token(this.tokenAutomaton.getState(), sb.toString());
            }
            sb.append(c);
            ++i;
        }
        this.hasMore = false;
        return new Token(this.tokenAutomaton.endState(), sb.toString());
    }

    private void makeTokens() {
        Vector<Token> vec = new Vector<Token>();
        while (this.hasMore()) {
            vec.add(this.innerNextToken());
        }
        boolean isString = false;
        boolean isChar = false;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < vec.size()) {
            Token t = (Token)vec.get(i);
            if (isString) {
                if (t.getKind() == 16) {
                    isString = false;
                    if (sb.length() > 0) {
                        vec.insertElementAt(new Token(53, sb.toString()), i);
                        ++i;
                        sb = new StringBuffer();
                    }
                } else {
                    sb.append(t.getVal());
                    vec.remove(i);
                    --i;
                }
            } else if (isChar) {
                if (t.getKind() == 17) {
                    isChar = false;
                } else {
                    t.setKind(54);
                }
            } else if (t.getKind() == 16) {
                isString = true;
            } else if (t.getKind() == 17) {
                isChar = true;
            } else if (t.getKind() == 2) {
                vec.remove(i);
                --i;
            }
            ++i;
        }
        this.tk = new Token[vec.size()];
        i = 0;
        while (i < this.tk.length) {
            this.tk[i] = (Token)vec.get(i);
            ++i;
        }
    }

    public Token[] getTokens() {
        Token[] tks = new Token[this.tk.length];
        System.arraycopy(this.tk, 0, tks, 0, tks.length);
        return tks;
    }

    private boolean hasMore() {
        return this.hasMore;
    }
}

