/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.sourcescan;

import junit.framework.TestCase;
import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.Tokenizer;

public class TokenizerTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testAttoMark() {
        Tokenizer t = new Tokenizer("@aho");
        TokenizerTest.assertEquals((String)"@", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"aho", (String)t.nextToken().getVal());
        t = new Tokenizer("hoge@aho");
        TokenizerTest.assertEquals((String)"hoge", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((int)55, (int)t.nextToken().getKind());
        TokenizerTest.assertEquals((String)"aho", (String)t.nextToken().getVal());
    }

    public void testComment() {
        Tokenizer t = new Tokenizer("i=1/*aho*/y //hoge   ");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"1", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"/*", (String)tk.getVal());
        TokenizerTest.assertEquals((int)50, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"aho", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"*/", (String)tk.getVal());
        TokenizerTest.assertEquals((int)51, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"y", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"//", (String)tk.getVal());
        TokenizerTest.assertEquals((int)52, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"hoge", (String)t.nextToken().getVal());
    }

    public void testStringWithKuuhaku() {
        Tokenizer t = new Tokenizer("\" a g\"");
        TokenizerTest.assertEquals((String)"\"", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)" a g", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"\"", (String)t.nextToken().getVal());
    }

    public void testStringWithKuuhaku2() {
        Tokenizer t = new Tokenizer("\" a g\"a");
        TokenizerTest.assertEquals((String)"\"", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)" a g", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"\"", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"a", (String)t.nextToken().getVal());
    }

    public void testCharWithKuuhaku() {
        Tokenizer t = new Tokenizer("' '\"a g\"");
        TokenizerTest.assertEquals((String)"'", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)" ", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"'", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"\"", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"a g", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"\"", (String)t.nextToken().getVal());
    }

    public void testIsNextLast() {
        Tokenizer t = new Tokenizer("i=1");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"1", (String)t.nextToken().getVal());
        t = new Tokenizer("i=11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"11", (String)t.nextToken().getVal());
    }

    public void testGetTokens() {
        Tokenizer t = new Tokenizer("p 1");
        Token[] tk = t.getTokens();
        TokenizerTest.assertEquals((String)"p", (String)tk[0].getVal());
        TokenizerTest.assertEquals((int)4, (int)tk[0].getKind());
        TokenizerTest.assertEquals((String)"1", (String)tk[1].getVal());
        TokenizerTest.assertEquals((int)1, (int)tk[1].getKind());
        t = new Tokenizer("p 12");
        tk = t.getTokens();
        TokenizerTest.assertEquals((String)"p", (String)tk[0].getVal());
        TokenizerTest.assertEquals((int)4, (int)tk[0].getKind());
        TokenizerTest.assertEquals((String)"12", (String)tk[1].getVal());
        TokenizerTest.assertEquals((int)1, (int)tk[1].getKind());
    }

    public void testTemp() {
        Tokenizer t = new Tokenizer("if(<<\t\ta_0?    >>a:b*=1),;");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"if", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"(", (String)tk.getVal());
        TokenizerTest.assertEquals((int)13, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"<<", (String)tk.getVal());
        TokenizerTest.assertEquals((int)46, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"a_0", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"?", (String)tk.getVal());
        TokenizerTest.assertEquals((int)41, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)">>", (String)tk.getVal());
        TokenizerTest.assertEquals((int)44, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"a", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)":", (String)tk.getVal());
        TokenizerTest.assertEquals((int)42, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"b", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"*=", (String)tk.getVal());
        TokenizerTest.assertEquals((int)38, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"1", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)")", (String)tk.getVal());
        TokenizerTest.assertEquals((int)14, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)",", (String)tk.getVal());
        TokenizerTest.assertEquals((int)48, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)";", (String)tk.getVal());
        TokenizerTest.assertEquals((int)43, (int)tk.getKind());
    }

    public void testPrint() {
        Tokenizer t = new Tokenizer("p 1");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"p", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"1", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
        t = new Tokenizer("p    11");
        TokenizerTest.assertEquals((String)"p", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"11", (String)t.nextToken().getVal());
    }

    public void testShiki() {
        Tokenizer t = new Tokenizer("i=11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"11", (String)t.nextToken().getVal());
        t = new Tokenizer("i = 11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"11", (String)t.nextToken().getVal());
    }

    public void testSeki() {
        Tokenizer t = new Tokenizer("i=x*11");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"i", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"=", (String)tk.getVal());
        TokenizerTest.assertEquals((int)5, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"x", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"*", (String)tk.getVal());
        TokenizerTest.assertEquals((int)6, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"11", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
        t = new Tokenizer("i = x3 * 101");
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"i", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"=", (String)tk.getVal());
        TokenizerTest.assertEquals((int)5, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"x3", (String)tk.getVal());
        TokenizerTest.assertEquals((int)4, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"*", (String)tk.getVal());
        TokenizerTest.assertEquals((int)6, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"101", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
    }

    public void testShou() {
        Tokenizer t = new Tokenizer("i=x/11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"/", (String)tk.getVal());
        TokenizerTest.assertEquals((int)7, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"11", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
    }

    public void testAmari() {
        Tokenizer t = new Tokenizer("i=x%11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"%", (String)tk.getVal());
        TokenizerTest.assertEquals((int)34, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"11", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
    }

    public void testTasuHiku() {
        Tokenizer t = new Tokenizer("i=x+11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"+", (String)tk.getVal());
        TokenizerTest.assertEquals((int)8, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"11", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
        t = new Tokenizer("i=x-11");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"-", (String)tk.getVal());
        TokenizerTest.assertEquals((int)9, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"11", (String)tk.getVal());
        TokenizerTest.assertEquals((int)1, (int)tk.getKind());
        t = new Tokenizer("-11");
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"-", (String)tk.getVal());
        TokenizerTest.assertEquals((int)9, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"11", (String)t.nextToken().getVal());
    }

    public void testPPMMKakeKake() {
        Tokenizer t = new Tokenizer("i=x++");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"++", (String)tk.getVal());
        TokenizerTest.assertEquals((int)10, (int)tk.getKind());
        t = new Tokenizer("i=x--");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"--", (String)tk.getVal());
        TokenizerTest.assertEquals((int)11, (int)tk.getKind());
        t = new Tokenizer("i=x**20");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"=", (String)t.nextToken().getVal());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"**", (String)tk.getVal());
        TokenizerTest.assertEquals((int)12, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"20", (String)t.nextToken().getVal());
    }

    public void testKakko() {
        Tokenizer t = new Tokenizer("(x/i)");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"(", (String)tk.getVal());
        TokenizerTest.assertEquals((int)13, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"/", (String)tk.getVal());
        TokenizerTest.assertEquals((int)7, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)")", (String)tk.getVal());
        TokenizerTest.assertEquals((int)14, (int)tk.getKind());
        t = new Tokenizer("(x+11)");
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"(", (String)tk.getVal());
        TokenizerTest.assertEquals((int)13, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"+", (String)tk.getVal());
        TokenizerTest.assertEquals((int)8, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"11", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)")", (String)tk.getVal());
        TokenizerTest.assertEquals((int)14, (int)tk.getKind());
    }

    public void testPiriod() {
        Tokenizer t = new Tokenizer("aho.get()");
        TokenizerTest.assertEquals((String)"aho", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)".", (String)tk.getVal());
        TokenizerTest.assertEquals((int)15, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"get", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"(", (String)tk.getVal());
        TokenizerTest.assertEquals((int)13, (int)tk.getKind());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)")", (String)tk.getVal());
        TokenizerTest.assertEquals((int)14, (int)tk.getKind());
    }

    public void testDoubleQSingleQ() {
        Tokenizer t = new Tokenizer("\"aho\"");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"\"", (String)tk.getVal());
        TokenizerTest.assertEquals((int)16, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"aho", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"\"", (String)tk.getVal());
        TokenizerTest.assertEquals((int)16, (int)tk.getKind());
    }

    public void testEsc() {
        Tokenizer t = new Tokenizer("\"ah\\\"o\"");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"\"", (String)tk.getVal());
        TokenizerTest.assertEquals((int)16, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"ah\\\"o", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"\"", (String)tk.getVal());
        TokenizerTest.assertEquals((int)16, (int)tk.getKind());
    }

    public void testArray() {
        Tokenizer t = new Tokenizer("x[10]");
        TokenizerTest.assertEquals((String)"x", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"[", (String)tk.getVal());
        TokenizerTest.assertEquals((int)19, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"10", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"]", (String)tk.getVal());
        TokenizerTest.assertEquals((int)20, (int)tk.getKind());
    }

    public void testBlock() {
        Tokenizer t = new Tokenizer("{aho}");
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((String)"{", (String)tk.getVal());
        TokenizerTest.assertEquals((int)21, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"aho", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((String)"}", (String)tk.getVal());
        TokenizerTest.assertEquals((int)22, (int)tk.getKind());
    }

    public void testCond() {
        Tokenizer t = new Tokenizer("i==0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        Token tk = t.nextToken();
        TokenizerTest.assertEquals((int)23, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"==", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i!=0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)25, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"!=", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i<0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)27, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"<", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i<=0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)26, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"<=", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i>0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)28, (int)tk.getKind());
        TokenizerTest.assertEquals((String)">", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i>=0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)29, (int)tk.getKind());
        TokenizerTest.assertEquals((String)">=", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i|0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)30, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"|", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i||0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)31, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"||", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i&0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)32, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"&", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i  &&  0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)33, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"&&", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
        t = new Tokenizer("i  ^  0");
        TokenizerTest.assertEquals((String)"i", (String)t.nextToken().getVal());
        tk = t.nextToken();
        TokenizerTest.assertEquals((int)35, (int)tk.getKind());
        TokenizerTest.assertEquals((String)"^", (String)tk.getVal());
        TokenizerTest.assertEquals((String)"0", (String)t.nextToken().getVal());
    }
}

