/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.plugin.logics;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class AddJarLogic {
    public static void addJar(IJavaProject project, String plugin, String jar) throws JavaModelException, MalformedURLException, IOException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        Path fileInPlugin = AddJarLogic.findFileInPlugin(plugin, jar);
        newEntries[newEntries.length - 1] = JavaCore.newLibraryEntry((IPath)fileInPlugin, null, null);
        project.setRawClasspath(newEntries, null);
    }

    public static boolean isIncludedInBuildPath(IJavaProject project, String plugin, String jar) throws JavaModelException, IOException {
        boolean retval = false;
        URL pluginURL = Platform.getBundle((String)plugin).getEntry("/");
        URL localPluginURL = FileLocator.toFileURL((URL)pluginURL);
        String jarPath = new Path(localPluginURL.getPath()).append(jar).toString();
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            String buildPath = "/" + entries[i].getPath();
            if (buildPath.equalsIgnoreCase(jarPath)) {
                retval = true;
            }
            ++i;
        }
        return retval;
    }

    private static void viewEntries(IClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            System.out.println("\u25cf" + entries[i].getPath());
            ++i;
        }
    }

    private static Path findFileInPlugin(String plugin, String file) throws MalformedURLException, IOException {
        URL pluginURL = Platform.getBundle((String)plugin).getEntry("/");
        URL jarURL = new URL(pluginURL, file);
        URL localJarURL = FileLocator.toFileURL((URL)jarURL);
        System.out.println(pluginURL);
        System.out.println(jarURL);
        System.out.println(localJarURL);
        return new Path(localJarURL.getPath());
    }
}

