/*
 * 쐬F 2005/03/29
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import java.util.Vector;


import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.CodeReader;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class ClassNameResolverTest extends TestCase {
	ClassNameResolver cnr;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"src\\fortest\\ArrayUserTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		cnr=new ClassNameResolver(ta.getTestClass().packageName(),ta.getTestClass().getImports());
	}
	
	public void testNX̃tl[₪擾łĂ邩(){
	    Vector names=cnr.getListFullClassNames("Token");
	    assertEquals(1,names.size());
	    assertEquals("org.kikaineko.source.util.Token",(String)names.get(0));
	    
	    names=cnr.getListFullClassNames("Hoge");
	    assertEquals(2,names.size());
	    assertEquals("fortest.Hoge",(String)names.get(0));
	    assertEquals("java.lang.Hoge",(String)names.get(1));
	}
	
	public void testGetClazz(){
		assertEquals(int.class,cnr.getClazz("int"));
		assertEquals(int.class,cnr.getClazz("int"));
		assertEquals(String.class,cnr.getClazz("String"));
		assertEquals(TestCase.class,cnr.getClazz("TestCase"));
		assertEquals(Token.class,cnr.getClazz("Token"));
		
		assertEquals(fortest.ArrayUser.class,cnr.getClazz("ArrayUser"));
	}
	
	public void testz̃NXĎĂ(){
		assertEquals(int[].class,ClassNameResolver.getArrayClass(int.class));
		assertEquals(int[][].class,ClassNameResolver.getArrayClass(int[].class));
	}
}
