package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.textui.MockMaker;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;

import junit.framework.TestCase;

public class SmallInterpreterForSetupTest extends TestCase {

	public void testZbgAbvĂ() throws Exception{

		LangMgn.setLang(new Java());
		TestAnalyst ta = null;
		TokenArray tokenArray = (new CodeReader(new File(
				"src\\fortest\\SetupTest.java")).getTokenArrayWithoutComment());

		// setUp\bh{ɂȂƂmF
		assertEquals(-1, tokenArray.indexOfVal("protected", "void", "setUp"));
		try {

			ta = new TestAnalyst(tokenArray);

			ta.analyze();
		} catch (Exception e) {
		}

		SmallInterpreter mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		try {
			mi.analyze();
		} catch (Exception e) {
		}

		TargetClass target = mi.getTargetClass();
		assertEquals(2, target.howManyMethods());
	}
	
	public void testMain(){
		try{
		    String[] ss={"-v","src\\fortest\\SetupTest.java"};
			MockMaker.main(ss);
		}catch(Throwable t){
		    System.out.println(t);
		}
		assertTrue(true);

		FileIO.cutting("src\\fortest\\MyClassForSetup.java", 300);
	}
}
