package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.textui.MockMaker;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;

import junit.framework.TestCase;

public class SmallInterpreterForTeardownTest extends TestCase {

	public void testTeardownƏ() throws Exception{

		TestAnalyst ta = null;
		TokenArray tokenArray = (new CodeReader(new File(
				"src\\fortest\\TeardownTest.java"))
				.getTokenArrayWithoutComment());

		// tearDown\bh{ɂ邱ƂmF
		assertTrue(tokenArray.indexOfVal("protected", "void", "tearDown") != -1);

		LangMgn.setLang(new Java());
		try {
			ta = new TestAnalyst(tokenArray);
			ta.analyze();
		} catch (Exception e) {
			e.printStackTrace();
		}

		SmallInterpreter mi = new SmallInterpreter(ta.getTestClass(), ta
				.getTargetClass());
		try {
			mi.analyze();
		} catch (Exception e) {
		}
		TargetClass target = mi.getTargetClass();
		assertEquals(2, target.howManyMethods());

	}
	public void testMain(){
		try{
		    String[] ss={"-v","src\\fortest\\TeardownTest.java"};
			MockMaker.main(ss);
		}catch(Throwable t){
		    System.out.println(t);
		}
		assertTrue(true);
		
		FileIO.cutting("src\\fortest\\MyClassForTeardown.java", 300);
	}
	

}
