package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.analysis.exception.UndefinedValueException;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.textui.MockMaker;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;

import junit.framework.TestCase;

public class SmallInterpreterForUndefUserTest extends TestCase {
	TargetClass target;

	public void testslcĐł邩() throws Exception {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(new CodeReader(new File(
					"src\\fortest\\undef\\UndefClassUserTest.java"))
					.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		target = mi.getTargetClass();
		assertTrue(target.hasUndefValue());
		UndefinedValue[] us = target.getUndefValues();
		assertEquals(1, us.length);
		UndefinedValue uv = us[0];
		assertEquals(2, uv.howManyHistories());
		assertEquals("gg();hoge();", uv.getHistoryAsRawString(0));
		assertEquals("gg();gg();hoge();", uv.getHistoryAsRawString(1));
	}

	public void testsl邪Ă邩() throws Exception {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(new CodeReader(new File(
					"src\\fortest\\undef\\UndefUserTest.java"))
					.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
		} catch (Exception e) {
			// TODO: handle exception
		}
		target = mi.getTargetClass();
		assertFalse(target.hasUndefValue());
	}

	public void testcslɃt@CiƗOł() {
		try {
			String[] ss = { "-v",
					"src\\fortest\\undef\\UndefForFinalClassTest.java" };
			MockMaker.main(ss);
			fail();
		} catch (UndefinedValueException t) {
			assertTrue(true);
		} catch (Throwable t) {
			fail();
		}
		assertTrue(true);
	}

	public void testMain() {
		try {
			String[] ss = { "-v", "src\\fortest\\undef\\UndefUserTest.java" };
			MockMaker.main(ss);
		} catch (Throwable t) {
			t.printStackTrace();
			fail();
		}
		assertTrue(true);
		FileIO.cutting("src\\fortest\\undef\\UndefUser.java", 300);
	}

	public void testMain2() {
		try {
			String[] ss = { "-v",
					"src\\fortest\\undef\\UndefClassUserTest.java" };
			MockMaker.main(ss);
		} catch (Throwable t) {
			t.printStackTrace();
			fail();
		}
		assertTrue(true);
		FileIO.cutting("src\\fortest\\undef\\UndefClassUser.java", 300);
	}

}
