package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

import junit.framework.TestCase;

public class SmallInterpreterForWhileTest extends TestCase {
	SmallInterpreter mi;

	VariableTable vt;

	TargetClass target;

	public void testWhile() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\WhileUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(0);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();

		assertEquals(int.class, vt.getType("simple1"));
		assertEquals(Integer.class, vt.getVal("simple1").getClass());
		assertEquals(new Integer((int) 1), vt.getVal("simple1"));

		assertEquals(new Integer((int) 2), vt.getVal("simple2"));
		assertEquals(new Integer((int) 2), vt.getVal("simple3"));
		assertEquals(new Integer((int) 1), vt.getVal("simple4"));
	}
	public void testBreakWhile() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\WhileUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(1);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();

		assertEquals(int.class, vt.getType("simple1"));
		assertEquals(Integer.class, vt.getVal("simple1").getClass());
		assertEquals(new Integer((int) 1), vt.getVal("simple1"));
		assertEquals(new Integer((int) 2), vt.getVal("simple3"));
		assertEquals(new Integer((int) 1), vt.getVal("simple4"));
		assertEquals(new Integer((int) 0), vt.getVal("simple5"));

	}
	public void testContinueWhile() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\WhileUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(2);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();
		
		assertEquals(int.class, vt.getType("simpleC0"));
		assertEquals(Integer.class, vt.getVal("simpleC0").getClass());
		assertEquals(new Integer((int) 13), vt.getVal("simpleC0"));
		
		assertEquals(int.class, vt.getType("simpleC1"));
		assertEquals(Integer.class, vt.getVal("simpleC1").getClass());
		assertEquals(new Integer((int) 103), vt.getVal("simpleC1"));
		assertEquals(new Integer((int) 103), vt.getVal("simpleC2"));

	}
}
