package org.kikaineko.mock.analysis;

import java.util.Stack;

import org.kikaineko.mock.analysis.exception.CannotUseUndefValueException;
import org.kikaineko.mock.framework.UndefinedValue;

import junit.framework.TestCase;

public class SmallInterpreterSupportorTest extends TestCase {
	public void testGetInc()throws Exception{
		assertEquals(new Integer(2), SmallInterpreterSupportor.getIncOrDec(new Integer(1), "+"));
		assertEquals(new Integer(0), SmallInterpreterSupportor.getIncOrDec(new Integer(1), "-"));
	}
	
	public void testCannotUseUndefValue(){
		try{
			SmallInterpreterSupportor.getIncOrDec(UndefinedValue.getCompornent(int.class, "a"), "+");
			fail();
		}catch (CannotUseUndefValueException e) {
			
		}
		try{
			SmallInterpreterSupportor.negatePush(null,UndefinedValue.getCompornent(int.class, "a"));
			fail();
		}catch (CannotUseUndefValueException e) {
			
		}
		try{
			SmallInterpreterSupportor.toByteOrShort(null,UndefinedValue.getCompornent(int.class, "a"));
			fail();
		}catch (CannotUseUndefValueException e) {
			
		}
		try{
			Stack valueStack=new Stack();
			valueStack.push(UndefinedValue.getCompornent(int.class, "a"));
			valueStack.push(new Integer(0));
			SmallInterpreterSupportor.operation(valueStack, null, "+");
			fail();
		}catch (CannotUseUndefValueException e) {
			
		}
	}
}
