package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class BlockBody {
	public static void run(SharedFields sf) throws Exception {
		TokenArray tokenArray=sf.tokenArray;
		String targetName=sf.targetName;
		ClassNameResolver classNameResolver=sf.classNameResolver;
		
		while (true) {
			Token t = tokenArray.get(sf.index++);
			String s=t.getVal();
			int kind=t.getKind();
			if (kind==TokenKind.Word && !s.equals(targetName) && isVariable(sf,s)) {
				
				if (tokenArray.getVal(sf.index).equals(".")) {
					// ܂ł݂ȂƕȂ
					Statement.run(sf, s);
				} else {
					Class c = classNameResolver.getClazz(s);
					Variable.run(sf, c);
				}
				
			} else if (!s.equals("}")) {
				Statement.run(sf, s);
			} else {
				break;
			}
		}
	}
	
	protected static boolean isVariable(SharedFields sf,String s) {
		return SmallInterpreterSupportor.isVariable(sf.classNameResolver, s);
	}
}
