package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.ToStringer;

public class TargetInvokingForUndefinedValue {

	public static void run(SharedFields sf, UndefinedValue undefV) throws Exception {
		doTargetInvokingForUndefinedValue(sf, undefV);
		sf.valueStack.push(undefV);
		// usedConcreteClassesUndefinedValueĂ܂̂ŁAQȂ̒lĂ
		sf.typeStack.push(void.class);
	}
	private static void doTargetInvokingForUndefinedValue(SharedFields sf, UndefinedValue undefV) throws Exception {
		String name = TargetInvoke.run(sf,sf.target);
		
		String s = ToStringer.getStrick(undefV,null);
		undefV.setMethodNameGeneratingThisUndefValue(name);
		undefV.setActualValueGenaratedByTargetClass(s);
		
		int currentHistorySymbol=sf.target.expectValueAtCurrentHistory(s);
		undefV.setTargetClassHistorySymbolGeneratingThisUndefValue(currentHistorySymbol);
		
		sf.target.overWriteMethodReType(name, undefV.getClassName());
	}

}
