package org.kikaineko.mock.framework;

import org.kikaineko.util.IntArray;

import junit.framework.TestCase;

public class DestroyMethodSeakerHelperTest extends TestCase {
	
	public void testŐʍ(){
		IntArray[] ias=new IntArray[2];
		ias[0]=new IntArray();
		ias[0].add(0);
		ias[0].add(1);
		ias[0].add(2);
		
		ias[1]=new IntArray();
		ias[1].add(0);
		ias[1].add(3);
		ias[1].add(4);
		ias[1].add(2);
		
		assertEquals(3, DestroyMethodSeakerHelper.łZqXg[̒(ias));
		assertTrue(DestroyMethodSeakerHelper.ʍ(ias, 0));
		assertEquals(0, DestroyMethodSeakerHelper.index(ias));
		
		
		ias=DestroyMethodSeakerHelper.Őʍ(ias);
		assertEquals(2, ias.length);
		assertEquals(2, ias[0].length());
		assertEquals(1, ias[0].get(0));
		assertEquals(2, ias[0].get(1));
		assertEquals(3, ias[1].length());
		assertEquals(3, ias[1].get(0));
		assertEquals(4, ias[1].get(1));
		assertEquals(2, ias[1].get(2));
	}
	public void test̑Őʍ(){
		IntArray[] ias=new IntArray[3];
		ias[0]=new IntArray();
		ias[0].add(0);
		ias[0].add(1);
		ias[0].add(2);
		
		ias[1]=new IntArray();
		ias[1].add(0);
		ias[1].add(1);
		ias[1].add(2);
		ias[1].add(3);
		ias[1].add(4);
		ias[1].add(2);
		
		ias[2]=new IntArray();
		ias[2].add(0);
		ias[2].add(1);
		ias[2].add(2);
		ias[2].add(2);
		
		
		assertEquals(3, DestroyMethodSeakerHelper.łZqXg[̒(ias));
		assertTrue(DestroyMethodSeakerHelper.ʍ(ias, 2));
		assertEquals(2, DestroyMethodSeakerHelper.index(ias));
		
		
		ias=DestroyMethodSeakerHelper.Őʍ(ias);
		assertEquals(3, ias.length);
		assertEquals(0, ias[0].length());
		assertEquals(3, ias[1].length());
		assertEquals(3, ias[1].get(0));
		assertEquals(4, ias[1].get(1));
		assertEquals(2, ias[1].get(2));
		assertEquals(1, ias[2].length());
		assertEquals(2, ias[2].get(0));
	}
	
	public void test̃eXgł̃p^[ŝłōēxmF(){
		//5,0,
		//5,2,
		//5,3,4,
		IntArray[] ias=new IntArray[3];
		ias[0]=new IntArray();
		ias[0].add(5);
		ias[0].add(0);
		
		ias[1]=new IntArray();
		ias[1].add(5);
		ias[1].add(2);
		
		ias[2]=new IntArray();
		ias[2].add(5);
		ias[2].add(3);
		ias[2].add(4);
		
		assertEquals(2, DestroyMethodSeakerHelper.łZqXg[̒(ias));
		assertTrue(DestroyMethodSeakerHelper.ʍ(ias, 0));
		assertFalse(DestroyMethodSeakerHelper.ʍ(ias, 1));
		assertEquals(0, DestroyMethodSeakerHelper.index(ias));
		
		ias=DestroyMethodSeakerHelper.Őʍ(ias);
		assertEquals(3, ias.length);
		assertEquals(1, ias[0].length());
		assertEquals(0, ias[0].get(0));
		
		assertEquals(1, ias[1].length());
		assertEquals(2, ias[1].get(0));
		
		assertEquals(2, ias[2].length());
		assertEquals(3, ias[2].get(0));
		assertEquals(4, ias[2].get(1));
	}
	
	
	public void test񂪂ȂƂ(){
		IntArray[] ias=new IntArray[3];
		ias[0]=new IntArray();
		ias[0].add(0);
		ias[0].add(1);
		ias[0].add(2);
		
		ias[1]=new IntArray();
		ias[1].add(3);
		ias[1].add(0);
		ias[1].add(1);
		ias[1].add(2);
		ias[1].add(3);
		ias[1].add(4);
		ias[1].add(2);
		
		ias[2]=new IntArray();
		ias[2].add(0);
		ias[2].add(1);
		ias[2].add(2);
		ias[2].add(2);
		
		
		assertEquals(3, DestroyMethodSeakerHelper.łZqXg[̒(ias));
		assertFalse(DestroyMethodSeakerHelper.ʍ(ias, 0));
		assertEquals(-1, DestroyMethodSeakerHelper.index(ias));
		
		
		ias=DestroyMethodSeakerHelper.Őʍ(ias);
		assertEquals(3, ias.length);
		assertEquals(3, ias[0].length());
		assertEquals(0, ias[0].get(0));
		assertEquals(1, ias[0].get(1));
		assertEquals(2, ias[0].get(2));
		
		assertEquals(7, ias[1].length());
		assertEquals(3, ias[1].get(0));
		assertEquals(0, ias[1].get(1));
		assertEquals(1, ias[1].get(2));
		assertEquals(2, ias[1].get(3));
		assertEquals(3, ias[1].get(4));
		assertEquals(4, ias[1].get(5));
		assertEquals(2, ias[1].get(6));
		
		assertEquals(4, ias[2].length());
		assertEquals(0, ias[2].get(0));
		assertEquals(1, ias[2].get(1));
		assertEquals(2, ias[2].get(2));
		assertEquals(2, ias[2].get(3));
	}
	public void testŌ̌Ăяo(){
		IntArray[] ias=new IntArray[2];
		ias[0]=new IntArray();
		ias[0].add(0);
		ias[0].add(1);
		ias[0].add(2);
		
		ias[1]=new IntArray();
		ias[1].add(0);
		ias[1].add(3);
		ias[1].add(4);
		ias[1].add(2);
		
		ias=DestroyMethodSeakerHelper.Ō̌Ăяo͋ʂ̂Ȃ̂ō(ias);
		assertEquals(2, ias.length);
		assertEquals(2, ias[0].length());
		assertEquals(0, ias[0].get(0));
		assertEquals(1, ias[0].get(1));
		assertEquals(3, ias[1].length());
		assertEquals(0, ias[1].get(0));
		assertEquals(3, ias[1].get(1));
		assertEquals(4, ias[1].get(2));
	}
	public void testŌ̌Ăяo2(){
		IntArray[] ias=new IntArray[2];
		ias[0]=new IntArray();
		ias[0].add(0);
		
		ias[1]=new IntArray();
		ias[1].add(0);
		ias[1].add(3);
		ias[1].add(4);
		ias[1].add(2);
		ias[1].add(0);
		
		ias=DestroyMethodSeakerHelper.Ō̌Ăяo͋ʂ̂Ȃ̂ō(ias);
		assertEquals(2, ias.length);
		assertEquals(0, ias[0].length());
		assertEquals(4, ias[1].length());
		assertEquals(0, ias[1].get(0));
		assertEquals(3, ias[1].get(1));
		assertEquals(4, ias[1].get(2));
		assertEquals(2, ias[1].get(3));
	}
}
