package org.kikaineko.mock.framework;

import java.util.Vector;

class TargetHistoryTerm {

	private int symbol;

	private String methodName;

	private String arg;

	private static Vector pool = new Vector();
	
	private boolean isDestroy=false;

	private TargetHistoryTerm(String methodName, String arg, int i) {
		this.symbol = i;
		this.methodName = methodName;
		this.arg = arg;
	}

	public static int getSymbol(String methodName, String arg) {
		TargetHistoryTerm tht = null;
		for (int i = 0; i < pool.size(); i++) {
			tht = (TargetHistoryTerm) pool.get(i);
			if (tht.equalsWith(methodName, arg)) {
				return tht.getSymbol();
			}
		}
		tht = new TargetHistoryTerm(methodName, arg, pool.size());
		pool.add(tht);
		return tht.getSymbol();
	}
	
	protected boolean isDestroy(){
		return isDestroy;
	}
	protected void mustBesDestroy(){
		isDestroy=true;
	}

	public static int count() {
		return pool.size();
	}

	public boolean equals(Object other) {
		if (this.methodName.equals(((TargetHistoryTerm) other).methodName)) {
			return this.arg.equals(((TargetHistoryTerm) other).arg);
		}
		return false;
	}

	public boolean equalsWith(String otherMethodName, String otherArg) {
		if (this.methodName.equals(otherMethodName)) {
			return this.arg.equals(otherArg);
		}
		return false;
	}

	public int getSymbol() {
		return symbol;
	}

	public static void initialize() {
		pool = new Vector();
	}

	public static TargetHistoryTerm getBySymbol(int symbol) {
		try {
			return (TargetHistoryTerm) pool.get(symbol);
		} catch (Exception e) {
		}
		return null;
	}

	public String getArg() {
		return arg;
	}

	public void setArg(String arg) {
		this.arg = arg;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

}
