package org.kikaineko.mock.framework;

import junit.framework.TestCase;

public class TargetHistoryTest extends TestCase {
	TargetHistory th;
	
	public void test{IȎgp@(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		assertEquals(1, th.length());
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		assertEquals(2, th.length());
		th.add("set(java.lang.String )","(java.lang.String(b) )");
		assertEquals(3, th.length());
		
		//\bhĂяôŁAV{lԂ
		int i=th.getHistoryTermSymbolAt(0);
		int j=th.getHistoryTermSymbolAt(1);
		assertEquals(i, j);
		//قȂ郁\bhɂ͈قȂV{lԂ
		j=th.getHistoryTermSymbolAt(2);
		assertTrue(i!=j);
		
		String s="set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(b) );";
		assertEquals(s, th.toString());
		
		i=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		
		TargetHistory th1=TargetHistory.getTargetHistoryBySymbol(i);
		assertEquals("set(java.lang.String )",th1.lastCallingMethod());
		assertEquals("(java.lang.String(b) )",th1.lastCallingArg());
		assertEquals("set(java.lang.String )(java.lang.String(b) );",th1.lastCallingTermAsString());	
	}	
	
	public void testrŃqXg[̃Rs[肽(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		assertEquals(1, th.length());
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		assertEquals(2, th.length());
		th.add("set(java.lang.String )","(java.lang.String(b) )");
		assertEquals(3, th.length());
		
		int th1Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		TargetHistory th1=TargetHistory.getTargetHistoryBySymbol(th1Index);
		assertEquals(3, th1.length());
		th.add("set(java.lang.String )","(java.lang.String(c) )");
		assertEquals(4, th.length());
		assertEquals(3, th1.length());
		String s="set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(b) );";
		assertEquals(s, th1.toString());
		
	}

	public void test̂v[͂Ȃ(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		
		int th1Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		int th2Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		assertEquals(th2Index, th1Index);
		assertEquals(1, TargetHistory.count());
		
		th=TargetHistory.makeCurrentHistory();
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		int th3Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		assertEquals(th3Index, th1Index);
		th.add("set(java.lang.String )","(java.lang.String(a) )");
		th3Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		assertTrue(th3Index!=th1Index);
		assertEquals(2, TargetHistory.count());
		
	}
}
