package org.kikaineko.mock.framework;

import junit.framework.TestCase;

public class VoidDestroyFilterTest extends TestCase {
	VoidDestroyFilter dmsf;
	TargetClass target;
    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        dmsf=new VoidDestroyFilter();
    }
    public void testVoid\bh() {
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "hoge()", null,null);
    	target.invokingMethod("int", "get()", null,null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target = dmsf.execute(target);
    	assertEquals(2, target.howManyMethods());
    	
    	assertEquals("hoge()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	
    }
}
