/*
 * 쐬F 2005/03/14
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.runner;

import java.io.File;
import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.FilterMgn;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;


/**
 * @BLbJ[̃RȀsRunner<br>
 * 
 * @author masayuki
 */
public class BaseRunner implements Runner {
    private File target;

    public void setCustumClassLoader(ClassLoader cl){
        KikainekoClassLoaderWrapper.setClassLoader(cl);
    }

    public File targetFile() {
        return target;
    }

    protected void setLang() {
        LangMgn.setLang(new Java());
    }

    
    protected StringBuffer overWrite(StringBuffer sb){
        if (target.exists()) {
            sb.append(System.getProperty("line.separator"));
            sb.append(System.getProperty("line.separator"));
            String[] codes = FileIO.getFileDatas(target);
            for (int i = 0; i < codes.length; i++) {
                sb.append("//");
                sb.append(codes[i]);
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb;
    }
    
    protected Analyst analystFactory(Object input)throws Exception{
        if(input instanceof File)
            return new TestAnalyst(new CodeReader((File)input)
                    .getTokenArrayWithoutComment());
        else if(input instanceof TestAnalyst)
            return new SmallInterpreter(((Analyst)input).getTestClass(), (((Analyst)input)).getTargetClass());
        return null;
    }
    
    protected TargetClass filter(TargetClass tc){
        return FilterMgn.doFilter(tc);
    }

    public final StringBuffer doRun(File test) throws Exception {
        setLang();
        
        Analyst preAnalyst = analystFactory(test);
        preAnalyst.analyze();

        Analyst interpreter = analystFactory(preAnalyst);
        interpreter.analyze();
        
        TargetClass tc=filter(interpreter.getTargetClass());

        Implementer im = new Implementer(tc);
        File parent = test.getParentFile();
        target = new File(parent, im.getTargetFile().getName());
        
        
        return overWrite(new StringBuffer(im.getCode()));
        
    }
}