package org.kikaineko.mock.runner;

import junit.framework.TestCase;

public class ClassFileSeekerTest extends TestCase {
	ClassFileSeeker cfs;
	protected void setUp() throws Exception {
		super.setUp();
		Path[] ps=new Path[3];
		ps[0]=new Path("C:\\Documents and Settings\\masayuki\\workspace\\kikainekomocker\\Sandbox",Path.YourProjectBinPath);
		ps[1]=new Path("C:\\eclipse\\plugins\\org.junit_3.8.1\\junit.jar",Path.LibPath);
		ps[2]=new Path("C:\\Documents and Settings\\masayuki\\workspace\\kikainekomocker\\KikainekoMocker\\bin",Path.OtherProjectBinPath);
		
		cfs=new ClassFileSeeker(ps);
	}

	public void testƃ\[g邩() {
		Path[] ps = new Path[4];
		try {
			ps[0] = new Path("C:\\eclipse", Path.JREPath);
			ps[1] = new Path("C:\\eclipse", Path.OtherProjectBinPath);
			ps[2] = new Path("C:\\eclipse", Path.LibPath);
			ps[3] = new Path("C:\\eclipse", Path.YourProjectBinPath);
		} catch (InvalidPathException e) {
			fail();
		}
		
		cfs=new ClassFileSeeker(ps);
		assertEquals(Path.YourProjectBinPath, cfs.getPath(0).getType());
		assertEquals(Path.OtherProjectBinPath, cfs.getPath(1).getType());
		assertEquals(Path.LibPath, cfs.getPath(2).getType());
		assertEquals(Path.JREPath, cfs.getPath(3).getType());
	}
	
	public void test̃vWFNg̃oCiĂ(){
		byte[] bs=cfs.findBytes("sandbox.Aaaa");
		assertNotNull(bs);
	}
	
	public void testJarƂ݂(){
		byte[] bs=cfs.findBytes("junit.framework.TestCase");
		assertNotNull(bs);
	}
	public void testق̃vWFNgƂ݂(){
		byte[] bs=cfs.findBytes("fortest.Calc");
		assertNotNull(bs);
	}
	
}
