package org.kikaineko.mock.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Vector;

public class FieldCollector {

	/**
	 * g̃tB[hAѐeNX̃tB[h擾
	 * 
	 * @param t
	 * @return
	 */
	public static Field getFieldByName(Object o, String name) {		
		Field[] fs = FieldCollector.getAllFields(o);
		AccessibleObject.setAccessible(fs, true);
		for (int i = 0; i < fs.length; i++) {
			if (fs[i].getName().equals(name)) {
				return fs[i];
			}
		}
		return null;
	}

	/**
	 * g̃tB[hAѐeNX̃tB[h擾
	 * 
	 * @param t
	 * @return
	 */
	public static Field[] getAllFields(Object o) {
		Vector vec = null;
		if (o instanceof Class) {
			//statcin
			vec = getAllFieldsAsVector((Class) o);
		} else {
			vec = getAllFieldsAsVector(o.getClass());
		}
		Field[] fs = new Field[vec.size()];
		for (int i = 0; i < fs.length; i++) {
			fs[i] = (Field) vec.get(i);
		}
		return fs;
	}

	private static Vector getAllFieldsAsVector(Class c) {
		Vector vec = new Vector();

		if (c.toString().equals(Object.class.toString())) {
			return vec;
		}

		Field[] fs = c.getDeclaredFields();
		for (int i = 0; i < fs.length; i++) {
			vec.add(fs[i]);
		}

		if (!c.getSuperclass().toString().equals(Object.class.toString())) {
			Vector vec2 = getAllFieldsAsVector(c.getSuperclass());
			for (int i = 0; i < vec2.size(); i++) {
				vec.add(vec2.get(i));
			}
		}

		return vec;
	}
}
