/*
 * 쐬F 2005/03/10
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.util;

import java.math.BigDecimal;

/**
 * ZsNXB
 * 
 * @author masayuki
 * 
 */
public class Operator {

	/**
	 * opŎw肳ꂽZo1,o2ɑ΂čsB
	 * Zʂ́@o2 op o1 ɓB
	 * Ao2=2 o1=1 op="-"Ƃ΁Aʂ́A2-1 = 1 ƂȂB
	 * @param o1
	 * @param o2
	 * @return
	 */
	public static Object operate(Object o1, Object o2, String op) {
		String s = strongType(o1, o2).getName();
		if (s.equals("java.lang.String"))
			return (Object) (o2.toString() + o1.toString());
		else if (s.equals("int"))
			return intOpe(o1, o2, op);
		else if (s.equals("long"))
			return longOpe(o1, o2, op);
		else if (s.equals("float"))
			return floatOpe(o1, o2, op);
		else if (s.equals("double"))
			return doubleOpe(o1, o2, op);
		else if (s.equals("byte"))
			return byteOpe(o1, o2, op);
		else if (s.equals("short"))
			return shortOpe(o1, o2, op);
		return null;
	}

	private static float ope(float f1, float f2, String op) {
		if (op.equals("+"))
			return f2 + f1;
		else if (op.equals("*"))
			return f2 * f1;
		else if (op.equals("-"))
			return f2 - f1;
		else if (op.equals("/"))
			return f2 / f1;
		else if (op.equals("%"))
			return f2 % f1;
		return 0;
	}

	private static BigDecimal opeBig(double d1, double d2, String op) {
		BigDecimal bd1 = new BigDecimal(d1);
		BigDecimal bd2 = new BigDecimal(d2);
		if (op.equals("+"))
			return bd2.add(bd1);
		else if (op.equals("*"))
			return bd2.multiply(bd1);
		else if (op.equals("-"))
			return bd2.add(bd1.negate());
		else if (op.equals("/"))
			return bd2.divide(bd1, 0);
		return null;
	}

	public static Class strongType(Object o1, Object o2) {
		if (o1 instanceof String || o2 instanceof String)
			return java.lang.String.class;
		else if (o1 instanceof Double || o2 instanceof Double)
			return double.class;
		else if (o1 instanceof Float || o2 instanceof Float)
			return float.class;
		else if (o1 instanceof Long || o2 instanceof Long)
			return long.class;
		else if (o1 instanceof Byte && o2 instanceof Byte)
			return byte.class;
		else if (o1 instanceof Short && o2 instanceof Short)
			return short.class;
		return int.class;
	}
	
	public static Class strongType(Class c1, Class c2) {
		if (c1==String.class || c2==String.class)
			return java.lang.String.class;
		else if (c1==double.class || c2==double.class)
			return double.class;
		else if (c1==float.class || c2==float.class)
			return float.class;
		else if (c1==long.class || c2==long.class)
			return long.class;
		return int.class;
	}
	
	private static Object shortOpe(Object o1, Object o2, String op) {
		short s1 = ((Number) o1).shortValue();
		short s2 = ((Number) o2).shortValue();
		return (Object) new Short((short) ope(s1, s2, op));
	}
	
	private static Object byteOpe(Object o1, Object o2, String op) {
		byte b1 = ((Number) o1).byteValue();
		byte b2 = ((Number) o2).byteValue();
		return (Object) new Byte((byte) ope(b1, b2, op));
	}

	private static Object intOpe(Object o1, Object o2, String op) {
		int i1 = ((Number) o1).intValue();
		int i2 = ((Number) o2).intValue();
		return (Object) new Integer((int) ope(i1, i2, op));
	}

	private static Object doubleOpe(Object o1, Object o2, String op) {
		double i1 = ((Number) o1).doubleValue();
		double i2 = ((Number) o2).doubleValue();
		return (Object) new Double(opeBig(i1, i2, op).doubleValue());
	}

	private static Object floatOpe(Object o1, Object o2, String op) {
		float i1 = ((Number) o1).floatValue();
		float i2 = ((Number) o2).floatValue();
		return (Object) new Float((float) ope(i1, i2, op));
	}

	private static Object longOpe(Object o1, Object o2, String op) {
		long l1 = ((Number) o1).longValue();
		long l2 = ((Number) o2).longValue();
		return (Object) new Long(opeBig(l1, l2, op).longValue());
	}
}