/*
 * Created on 2005/02/19
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.sourcescan;

import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenKind;

/**
 * Rg𔲂o߂ɎgpI[g}g
 * @author Masayuki Ioki
 */
public class CommentAutomaton {
	public static final int LineCommentStart=0;
	public static final int InComment=1;
	public static final int OutComment=-1;
	public static final int CommentStart=2;
	public static final int CommentClose=3;
	public static final int StringStart=4;
	public static final int StringEnd=5;
	public static final int InString=6;
	public static final int CharStart=7;
	public static final int CharEnd=8;
	public static final int InChar=9;
	
	private int state;
	public CommentAutomaton(){
		state=OutComment;
	}
	
	/**
	 * @param token
	 * @return
	 */
	public int state(Token token) {
		int kind=token.getKind();
		if(state==OutComment){
			outComment(kind);
		}else if(state==CommentStart){
			commentStart(kind);
		}else if(state==InComment)
			inComment(kind);
		else if(state==StringStart)
			stringStart(kind);
		else if(state==InString)
			inString(kind);
		else if(state==CharStart)
			charStart(kind);
		else if(state==InChar)
			inChar(kind);
		else
			state=findState(kind);
		
		return state;
	}
	
	private void outComment(int kind){
		state=findState(kind);
	}
	private void commentStart(int kind){
		if(kind==TokenKind.CommentClose)
			state=CommentClose;
		else
			state=InComment;
	}
	private void inComment(int kind){
		if(kind==TokenKind.CommentClose)
			state=CommentClose;
	}
	private void stringStart(int kind){
		if(kind==TokenKind.DoubleQ)
			state=StringEnd;
		else
			state=InString;
	}
	private void inString(int kind){
		if(kind==TokenKind.DoubleQ)
			state=StringEnd;
	}
	private void charStart(int kind){
		if(kind==TokenKind.SingleQ)
			state=CharEnd;
		else
			state=InChar;
	}
	private void inChar(int kind){
		if(kind==TokenKind.SingleQ)
			state=CharEnd;
	}

	/**
	 * @param kind
	 * @return
	 */
	private int findState(int kind) {
		if(kind == TokenKind.LineComment)
			return LineCommentStart;
		else if(kind == TokenKind.CommentOpen)
			return CommentStart;
		else if(kind == TokenKind.DoubleQ)
			return StringStart;
		else if(kind==TokenKind.SingleQ)
			return CharStart;
		
		return OutComment;
	}

	/**
	 * @return
	 */
	public boolean isStateComment() {
		if(state==CommentAutomaton.CommentStart){
			return true;
		}else if(state==CommentAutomaton.InComment){
			return true;
		}else if(state==CommentAutomaton.CommentClose)
			return true;
			
		return false;
	}

	/**
	 * @return
	 */
	public boolean isLiteral() {
		if(state==StringEnd)
			return true;
		else if(state==StringStart)
			return true;
		else if(state==InString)
			return true;
		else if(state==CharEnd)
			return true;
		else if(state==CharStart)
			return true;
		else if(state==InChar)
			return true;
		return false;
	}

}
