package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

import junit.framework.TestCase;

public class SmallInterpreterForDoWhileTest extends TestCase {
	SmallInterpreter mi;

	VariableTable vt;

	TargetClass target;

	public void testWhile() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\DoWhileUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(0);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();

		assertEquals(int.class, vt.getType("simple1"));
		assertEquals(Integer.class, vt.getVal("simple1").getClass());
		assertEquals(new Integer((int) 2), vt.getVal("simple1"));

		assertEquals(new Integer((int) 2), vt.getVal("simple2"));
		
		assertEquals(new Integer((int) 2), vt.getVal("simple3"));
		

		assertEquals(new Integer((int) 0), vt.getVal("simple4"));
		assertEquals(new Integer((int) 1), vt.getVal("simple5"));
		
		assertEquals(new Integer((int) 11), vt.getVal("lastDoWhile"));
	}
}
