package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

import junit.framework.TestCase;

public class SmallInterpreterForMultiArrayTest extends TestCase {
	SmallInterpreter mi;

	VariableTable vt;

	TargetClass target;

	public void testPȒ`̑z() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\multiarray\\MultiArrayUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(0);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();
		
		assertEquals(new Integer((int) 10), vt.getVal("simpleI"));
		
		assertEquals(int[][].class, vt.getType("is"));
		assertEquals(new Integer((int) 1), vt.getVal("i"));
		
		assertEquals(int[][][].class, vt.getType("is2"));
		assertEquals(new Integer((int) 2), vt.getVal("i2"));
		
		assertEquals(int[][][][].class, vt.getType("is3"));
		assertEquals(new Integer((int) 3), vt.getVal("i3"));
		int[][][][] tempIs3=(int[][][][])vt.getVal("is3");
		assertEquals(4, tempIs3.length);
		assertEquals(3, tempIs3[0].length);
		assertEquals(2, tempIs3[0][0].length);
		assertEquals(1, tempIs3[0][0][0].length);
		
		assertEquals(int[][].class, vt.getType("is4"));
		int[][] tempIs4=(int[][])vt.getVal("is4");
		assertEquals(4, tempIs4.length);
		assertNull(tempIs4[0]);
		
		int[][] tempIs5=(int[][])vt.getVal("is5");
		assertNotNull(tempIs5[0]);
		assertEquals(0, tempIs5[0][0]);
		assertEquals(10, tempIs5[0].length);
		assertNull(tempIs5[1]);
	}

	public void testʒ`̑z() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\multiarray\\MultiArrayUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(1);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();
		
		assertEquals(new Integer((int) 100), vt.getVal("simpleI2"));
		
		assertEquals(int[][].class, vt.getType("is"));
		assertEquals(new Integer((int) 1), vt.getVal("i"));
		
		assertEquals(int[][][][].class, vt.getType("is3"));
		assertEquals(new Integer((int) 3), vt.getVal("i3"));
		int[][][][] tempIs3=(int[][][][])vt.getVal("is3");
		assertEquals(4, tempIs3.length);
		assertEquals(3, tempIs3[0].length);
		assertEquals(2, tempIs3[0][0].length);
		assertEquals(1, tempIs3[0][0][0].length);
		
		assertEquals(int[][].class, vt.getType("is4"));
		int[][] tempIs4=(int[][])vt.getVal("is4");
		assertEquals(4, tempIs4.length);
		assertNull(tempIs4[0]);
		
		int[][] tempIs5=(int[][])vt.getVal("is5");
		assertNotNull(tempIs5[0]);
		assertEquals(0, tempIs5[0][0]);
		assertEquals(10, tempIs5[0].length);
		assertNull(tempIs5[1]);
		
	}
	public void test錾Ə1z() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\multiarray\\MultiArrayUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(2);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();
		
		assertEquals(new Integer((int) 100), vt.getVal("simpleI3"));
	}
}
