package org.kikaineko.mock.analysis;

import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.ImportForJUnit4;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.util.IntArray;

public class TestAnalystForJUnit4 extends TestAnalyst {
	IntArray ignoreTestMethodIndex;

	public TestAnalystForJUnit4(TokenArray inTa) {
		super(inTa);
		ignoreTestMethodIndex = new IntArray();
	}

	/**
	 * @return
	 */
	protected void setTestClass() throws Exception {

		String pack = getPackage();

		Import[] im = getImports();

		int index = ta.indexOfVal("class");
		String name = ta.getVal(index + 1);

		tc = new TestClass(pack, name);
		tc.setImports(im);

		ta = ta.takeSubArray(ta.indexOfVal("{", index) + 1, getIndexOfClosed(
				ta, index, "{", "}"));
	}

	private String getPackage() {
		int index = ta.indexOfVal("package");
		if (index == -1) {
			// ftHgpbP[W
			return "";
		}
		int endindex = ta.indexOfVal(";", index);
		StringBuffer sb = new StringBuffer();
		for (int i = index + 1; i < endindex; i++) {
			sb.append(ta.getVal(i));
		}
		return sb.toString();
	}

	protected Import[] getImports() {
		int num = ta.howManyOfVal("import");
		Import[] im = new Import[num];
		for (int i = 0; i < im.length; i++) {
			int from = ta.indexOfVal("import");
			int end = ta.indexOfVal(";", from);
			im[i] = new ImportForJUnit4(ta.takeSubArray(from, end + 1));
		}
		return im;

	}

	protected int getIndexOfTestMethod() {
		int start = getIndexOfTestMethodForJUnit4();
		if(start==-1)
			return -1;
		
		int flag=ta.indexOfVal("@", "Ignore", start - 2);
		if(flag!=-1 && flag <start){
			ignoreTestMethodIndex.add(tc.howManyTestMethods());
		}else{
			flag=ta.indexOfVal("@", "Ignore", start - 2);
			if(flag!=-1 && flag <start)
				ignoreTestMethodIndex.add(tc.howManyTestMethods());
		}
		
		return start;
	}

	private int getIndexOfTestMethodForJUnit4() {
		int start = -1;
		do {
			start = ta.indexOfVal("@", "Test", start + 1);
			if (start != -1) {
				if (ta.indexOfVal("public", "void", start + 1) != -1)
					return start;
			}
		} while (start != -1);
		return -1;
	}

	protected int getIndexOfSetUp() {
		int index = ta.indexOfVal("@", "Before");
		if (index != -1) {
			return ta.indexOfVal("public", "void", index);
		}
		return -1;
	}

	protected int getIndexOfTearDown() {
		int index = ta.indexOfVal("@", "After");
		if (index != -1) {
			return ta.indexOfVal("public", "void", index);
		}
		return -1;
	}

	protected void tearDownForAnalyze() throws Exception {
		for (int i = 0; i < ignoreTestMethodIndex.length(); i++) {
			tc.removeTestMethod(ignoreTestMethodIndex.get(i) - i);
		}
		checkbJ[@();
	}

	protected void checkbJ[@() throws Exception {

	}

}
