package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.sourcescan.CodeReader;

import junit.framework.TestCase;

public class TestAnalystForJUnit4Test extends TestCase {
	TestAnalystForJUnit4 ta4;
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		ta4=new TestAnalystForJUnit4(new CodeReader(new File("src\\fortest\\junit4\\SampleTestCaseJunit4")).getTokenArrayWithoutComment());
		ta4.analyze();
	}
	public void testGetName(){
		TestClass test=ta4.getTestClass();
		assertEquals("aho",test.packageName());
		assertEquals("AhoTest",test.getClassName());
		
		TargetClass tc=ta4.getTargetClass();
		assertEquals("Hoge",tc.getClassName());
		assertEquals("hoge",tc.getInstanceName());
		
		assertEquals(6, test.getImports().length);
		assertEquals("org.junit.Assert.", test.getImport(0).getPackageName());
		
		assertEquals(2, test.howManyTestMethods());
		
		assertEquals("setUp()",test.getSetUp().getName());
		assertEquals("tearDown()",test.getTearDown().getName());
	}
}
