package org.kikaineko.mock.analysis.innersi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Stack;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.MethodSeacher;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.exception.MaybeCannotCompileException;
import org.kikaineko.mock.analysis.exception.TypeMissMuchException;
import org.kikaineko.mock.util.FieldCollector;
import org.kikaineko.source.util.TokenArray;

public class MethodCalling {
	public static void run(SharedFields sf,String type) throws Exception {
		TokenArray tokenArray=sf.tokenArray;
		Stack valueStack=sf.valueStack;
		TypeOwner typeStack=sf.typeStack;
		ClassNameResolver classNameResolver=sf.classNameResolver;
		
		String name = tokenArray.getVal(sf.index++);
		Object[] argsO = null;
		Class[] cs = null;

		if (tokenArray.getVal(sf.index).equals("(")) {
			Object[] oss = Arg.run(sf);
			if (oss != null) {
				argsO = (Object[]) oss[0];
				cs = (Class[]) oss[1];
			}
		} else {
			type = "field";
		}

		Object targetObject = null;

		try {
			Object ro = null;
			if (type.equals("method")) {
				targetObject = valueStack.pop();
				typeStack.pop();
				Class clazz = null;
				if (targetObject instanceof Class) {
					clazz = (Class) targetObject;
				} else {
					clazz = targetObject.getClass();
				}
				// 萳mɈv郁\bh
				Method m = MethodSeacher.search(clazz, name, cs);
				
				ro = m.invoke(targetObject, argsO);
				typeStack.push(m.getReturnType());
			} else if (type.equals("field")) {

				targetObject = valueStack.pop();
				typeStack.pop();

				if (name.equals("class")) {
					ro = targetObject;
					typeStack.push(Class.class);
				} else {
					Field f = FieldCollector.getFieldByName(targetObject, name);
					ro = f.get(targetObject);
					typeStack.push(ro.getClass());
				}
				sf.index--;// )҂Ă̂ŁA킴ƈǂ

			} else {
				Class clazz = classNameResolver.getClazz(name);
				Constructor csr = clazz.getConstructor(cs);
				ro = csr.newInstance(argsO);
				typeStack.push(ro.getClass());
			}
			valueStack.push(ro);
		} catch (Exception e) {
			throw e;
		}

		sf.index++;
		if (tokenArray.getVal(sf.index).equals(".")) {
			sf.index++;
			MethodCalling.run(sf, "method");
		} else if (tokenArray.getVal(sf.index).equals("=")) {
			if (!type.equals("field")) {
				// ɂătB[hȂRpCG[
				throw new MaybeCannotCompileException(tokenArray.get(sf.index)
						.getLineNo(), "=");
			}
			// 񂾓z
			valueStack.pop();
			typeStack.pop();
			sf.index++;

			Expression.run(sf);

			typeStack.pop();

			Field f = FieldCollector.getFieldByName(targetObject, name);
			try {
				f.set(targetObject, valueStack.pop());
			} catch (Exception e) {
				throw new TypeMissMuchException(tokenArray.get(sf.index)
						.getLineNo());
			}

		}
	}

}
