package org.kikaineko.mock.framework;

import junit.framework.TestCase;

public class TargetHistoryTermTest extends TestCase {
	protected void setUp() throws Exception {
		super.setUp();
		TargetHistoryTerm.initialize();
	}
	public void test{IȎgp@(){
		String[] s={"java.lang.String(a)"};
		int tht1=TargetHistoryTerm.getSymbol("set(java.lang.String )",s);
		assertEquals(1, TargetHistoryTerm.count());

		String[] s2={"java.lang.String(b)"};
		TargetHistoryTerm.getSymbol("set(java.lang.String )",s2);
		assertEquals(2, TargetHistoryTerm.count());
		
		//ߋɑꂽ̂𑫂ĂÂԂ
		int tht3=TargetHistoryTerm.getSymbol("set(java.lang.String )",s);
		assertEquals(2, TargetHistoryTerm.count());
		assertEquals(tht1, tht3);
	}
	public void test{IȎgp@2(){
		String[] s={"java.lang.String(a)"};
		int tht1=TargetHistoryTerm.getSymbol("set(java.lang.String )",s);
		TargetHistoryTerm tht=TargetHistoryTerm.getBySymbol(tht1);
		assertEquals("{\"set(java.lang.String )\",\"java.lang.String(a)\"}", tht.toStringAsStringArray());
	}
	public void testł邩(){
		String[] s={"java.lang.String(c)"};
		TargetHistoryTerm.getSymbol("set(java.lang.String )",s);
		assertEquals(1, TargetHistoryTerm.count());
		String[] s2={"java.lang.String(d)"};
		TargetHistoryTerm.getSymbol("set(java.lang.String )",s2);
		assertEquals(2, TargetHistoryTerm.count());
		
		TargetHistoryTerm.initialize();
		assertEquals(0, TargetHistoryTerm.count());
	}
	
	public void testV{擾ł邩(){
		String[] s={"java.lang.String(c)"};
		int tht1=TargetHistoryTerm.getSymbol("set(java.lang.String )",s);
		assertEquals(1, TargetHistoryTerm.count());
		String[] s2={"java.lang.String(d)"};
		int tht2=TargetHistoryTerm.getSymbol("set(java.lang.String )",s2);
		assertEquals(2, TargetHistoryTerm.count());
		
		TargetHistoryTerm tht3=TargetHistoryTerm.getBySymbol(0);
		assertEquals(tht1, tht3.getSymbol());
		tht3=TargetHistoryTerm.getBySymbol(1);
		assertEquals(tht2, tht3.getSymbol());
		tht3=TargetHistoryTerm.getBySymbol(-1);
		assertNull(tht3);
	}
}
