package org.kikaineko.mock.framework;

import junit.framework.TestCase;

public class TargetHistoryTest extends TestCase {
	TargetHistory th;
	
	public void test{IȎgp@(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();

		String[] s={"java.lang.String(a)"};
		th.add("set(java.lang.String )",s);
		assertEquals(1, th.length());
		th.add("set(java.lang.String )",s);
		assertEquals(2, th.length());
		String[] s2={"java.lang.String(b)"};
		th.add("set(java.lang.String )",s2);
		assertEquals(3, th.length());
		
		//\bhĂяôŁAV{lԂ
		int i=th.getHistoryTermSymbolAt(0);
		int j=th.getHistoryTermSymbolAt(1);
		assertEquals(i, j);
		//قȂ郁\bhɂ͈قȂV{lԂ
		j=th.getHistoryTermSymbolAt(2);
		assertTrue(i!=j);
		
		String s3="set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(b) );";
		assertEquals(s3, th.toString());
		
		i=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		
		TargetHistory th1=TargetHistory.getTargetHistoryBySymbol(i);
		assertEquals("set(java.lang.String )",th1.lastCallingMethod());
		assertEquals("(java.lang.String(b) )",th1.lastCallingArg());
		assertEquals("set(java.lang.String )(java.lang.String(b) );",th1.lastCallingTermAsString());	
	}
	public void test{IȎgp@2(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();

		String[] s={"java.lang.String(a)"};
		th.add("set(java.lang.String )",s);
		assertEquals(1, th.length());
		th.add("set(java.lang.String )",s);
		assertEquals(2, th.length());
		String[] s2={"java.lang.String(b)"};
		th.add("set(java.lang.String )",s2);
		assertEquals(3, th.length());
		
		//\bhĂяôŁAV{lԂ
		int i=th.getHistoryTermSymbolAt(0);
		int j=th.getHistoryTermSymbolAt(1);
		assertEquals(i, j);
		//قȂ郁\bhɂ͈قȂV{lԂ
		j=th.getHistoryTermSymbolAt(2);
		assertTrue(i!=j);
		
		String[] ss=th.getHistoryTerms();
		assertEquals(3, ss.length);
		assertEquals("{\"set(java.lang.String )\",\"java.lang.String(a)\"}", ss[0]);
		assertEquals("{\"set(java.lang.String )\",\"java.lang.String(a)\"}", ss[1]);
		assertEquals("{\"set(java.lang.String )\",\"java.lang.String(b)\"}", ss[2]);
		
	}
	
	public void testrŃqXg[̃Rs[肽(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();
		String[] s={"java.lang.String(a)"};
		th.add("set(java.lang.String )",s);
		assertEquals(1, th.length());
		th.add("set(java.lang.String )",s);
		assertEquals(2, th.length());
		String[] s2={"java.lang.String(b)"};
		th.add("set(java.lang.String )",s2);
		assertEquals(3, th.length());
		
		int th1Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		TargetHistory th1=TargetHistory.getTargetHistoryBySymbol(th1Index);
		assertEquals(3, th1.length());
		String[] s3={"java.lang.String(c)"};
		th.add("set(java.lang.String )",s3);
		assertEquals(4, th.length());
		assertEquals(3, th1.length());
		String s4="set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(a) );set(java.lang.String )(java.lang.String(b) );";
		assertEquals(s4, th1.toString());
		
	}

	public void test̂v[͂Ȃ(){
		TargetHistory.initialize();
		th=TargetHistory.makeCurrentHistory();
		String[] s={"java.lang.String(a)"};
		th.add("set(java.lang.String )",s);
		
		int th1Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		int th2Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		assertEquals(th2Index, th1Index);
		assertEquals(1, TargetHistory.count());
		
		th=TargetHistory.makeCurrentHistory();
		th.add("set(java.lang.String )",s);
		int th3Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		assertEquals(th3Index, th1Index);
		th.add("set(java.lang.String )",s);
		th3Index=th.getSymbolOfFreezedCurrentHistoryAndPoolIt();
		assertTrue(th3Index!=th1Index);
		assertEquals(2, TargetHistory.count());
		
	}
}
