/*
 * 쐬F 2005/06/01
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.framework;

import org.kikaineko.source.util.LangMgn;

/**
 * ^[Qbg̎\bhǗNX
 * 
 * @author Masayuki Ioki
 * 
 */
public class TargetMethodMgn {
	private SetArray methodList;

	public TargetMethodMgn() {
		methodList = new SetArray();
	}

	public void add(String name) {
		methodList.add(name);
	}

	public void add(String name, String type) {
		String[] exceptions = null;
		if (methodList.hasName(name)) {
			overWriteReturnType(name, type);
			// exceptions = getExceptions(name);

			// methodList.add(name, new TargetMethod(name, type, exceptions));
		} else {
			exceptions = new String[0];
			methodList.add(name, new TargetMethod(name, type, exceptions));
		}
	}

	public void setReturnType(String name, String returnType) {
		String[] exceptions = null;
		if (methodList.hasName(name)) {
			exceptions = getExceptions(name);
		} else {
			exceptions = new String[0];
		}
		methodList.setValue(name,
				new TargetMethod(name, returnType, exceptions));
	}

	public void overWriteReturnType(String name, String type) {
		TargetMethod dest = (TargetMethod) methodList.getValue(name);
		String destReturnType = dest.getReturnType();
		if (type.equals(destReturnType)) {
			return;
		} else if (type.equals("void")) {
			if(destReturnType.trim().length()!=0){
				return;
			}else{
				dest.setReturnType(type);
			}
		}
		
		if (destReturnType.equals("void")) {
			dest.setReturnType(type);
		} else if (destReturnType.equals("java.lang.Object")) {
			// Object^ŏʂȂ̂ł͕ύXȂ
		} else if (type.equals("java.lang.Object")) {
			// ŏʂɐݒ肳ꍇ͖ɐݒ肷
			dest.setReturnType(type);
		} else {
			Class destC = LangMgn.getClassByName(dest.getReturnType());
			Class typeC = LangMgn.getClassByName(type);
			if (destC.isAssignableFrom(typeC)) {
				// destCeȂ̂ŉȂ
			} else if (typeC.isAssignableFrom(destC)) {
				// destCeȂAtypeCeȂ̂ŁAݒ肵Ȃ
				dest.setReturnType(type);
			} else if (Object.class.isAssignableFrom(typeC)) {
				// destCtypeCƂ̊Ԃɒڂ̐eq֌WȂ
				// typeCObject̊Ԃɐeq֌W΁AObjectɂĂ܂ƂƂ
				dest.setReturnType("java.lang.Object");
			} else {
				// L̂łȂꍇAƂ肠ݒ肵Ă
				dest.setReturnType(type);
			}
		}
	}

	public void setVisibl(String name, String vis) {
		((TargetMethod) methodList.getValue(name)).setVisible(vis);
	}

	public String getName(int i) {
		return methodList.getName(i);
	}

	public String getReturnType(int i) {
		return ((TargetMethod) methodList.getValue(i)).getReturnType();
	}

	public String getVisible(int i) {
		return ((TargetMethod) methodList.getValue(i)).getVisible();
	}

	public String getVisible(String name) {
		return ((TargetMethod) methodList.getValue(name)).getVisible();
	}

	public int size() {
		return methodList.size();
	}

	public boolean hasName(String name) {
		return methodList.hasName(name);
	}

	public void addException(String methodName, String exceptionName) {
		if (hasName(methodName)) {
			TargetMethod method = (TargetMethod) methodList
					.getValue(methodName);
			if (!method.hasException(exceptionName)) {
				method.addException(exceptionName);
			}
		} else {
			// Ułvoid^ƂĂ
			add(methodName, "void");
			((TargetMethod) methodList.getValue(methodName))
					.addException(exceptionName);
		}
	}

	public String getException(String methodName, int i) {
		return ((TargetMethod) methodList.getValue(methodName)).getException(i);
	}

	public String[] getExceptions(String name) {
		TargetMethod method = (TargetMethod) methodList.getValue(name);
		String[] exceptions = new String[method.howManyExceptions()];
		for (int index = 0; index < exceptions.length; index++) {
			exceptions[index] = method.getException(index);
		}
		return exceptions;
	}

	public String[] getExceptions(int i) {
		TargetMethod method = (TargetMethod) methodList.getValue(i);
		String[] exceptions = new String[method.howManyExceptions()];
		for (int index = 0; index < exceptions.length; index++) {
			exceptions[index] = method.getException(index);
		}
		return exceptions;
	}

	public boolean hasException(int i) {
		TargetMethod method = (TargetMethod) methodList.getValue(i);
		return method.howManyExceptions() > 0;
	}

	public boolean isDestroyMethod(int i) {
		TargetMethod method = (TargetMethod) methodList.getValue(i);
		return method.isDestroyMethod();
	}

	public void mustBeDestroyMethod(int i) {
		TargetMethod method = (TargetMethod) methodList.getValue(i);
		method.mustBeDestroyMethod();
	}
}
