package org.kikaineko.mock.inmemory;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.FilterMgn;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

public class KikainekoMockerInMemory {
	public static Object createObjectFrom(String filePath,
			Class targetClassInterface) throws Exception {

		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(filePath))
				.getTokenArrayWithoutComment());
		ta.analyze();

		SmallInterpreter si = new SmallInterpreter(ta.getTestClass(), ta
				.getTargetClass());
		si.analyze();
		TargetClass tc = FilterMgn.doFilter(si.getTargetClass());

		return createObjectThisTarget(tc, targetClassInterface);
	}

	protected static Object createObjectThisTarget(TargetClass tc,
			Class targetClassInterface) throws Exception {
		InvocationHandler handler = new KikainekoMockerInvocationHandler();
		((KikainekoMockerInvocationHandler) handler).initialize(tc);
		return Proxy.newProxyInstance(targetClassInterface.getClassLoader(),
				new Class[] { targetClassInterface }, handler);
	}
}
