package org.kikaineko.mock.runner;

import java.io.File;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import org.kikaineko.source.util.LangMgn;
import org.kikaineko.util.FileIO;
import org.kikaineko.util.StringMgn;

/**
 * KikainekoClassLoaderWithPathsgp\B ^ꂽtNXƁApathclasst@CT
 * 
 * @author masayuki
 * 
 */
public class ClassFileSeeker {
	private Path[] paths;

	private static final String separator = System.getProperty("file.separator");
	private static final char separatorChar=StringMgn.firstChar(separator);
	private static final char separatorCharInJar='/';
	private static final char packagerSeparatorChar=StringMgn.firstChar(LangMgn.getPackagerSeparator());

	public ClassFileSeeker(Path[] ps) {
		paths = ps;
		Arrays.sort(paths, new java.util.Comparator() {
			public int compare(Object o1, Object o2) {
				return ((Path) o1).getType() - ((Path) o2).getType();
			}
		});
	}

	public Path getPath(int i) {
		return paths[i];
	}

	public byte[] findBytes(String className) {
		for (int i = 0; i < paths.length; i++) {
			if (paths[i].getType() == Path.YourProjectBinPath
					|| paths[i].getType() == Path.OtherProjectBinPath) {
				
				String fullPath = paths[i].getRawPath();
				fullPath += separator;
				fullPath += className.replace(packagerSeparatorChar, separatorChar);
				fullPath += LangMgn.getBinSuffix();
				
				File f = new File(fullPath);
				if (f.exists()) {
					return FileIO.getFileDataAsBytes(f);
				}
			} else if (paths[i].getType() == Path.LibPath) {
				try {
					JarFile jf = new JarFile(paths[i].getRawPath());
					String classNameForJar = className.replace(packagerSeparatorChar,separatorCharInJar);
					
					JarEntry je = jf.getJarEntry(classNameForJar
							+ LangMgn.getBinSuffix());
					if (je != null) {
						return FileIO.getFileDataAsByteFromInputStream(jf
								.getInputStream(je));
					}
				} catch (Exception e) {
				}
			}
		}
		return null;
	}
}
