/*
 * Created on 2005/02/22
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.mock.runner;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

import org.kikaineko.mock.framework.FilterMgn;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.mock.util.Version;
import org.kikaineko.source.util.LangMgn;

/**
 * @author masayuki
 */
public class Implementer {
	protected TargetClass targetClass;

	private String historyMethodName = "kikainekoHistoryAdd";

	protected String historyFieldName = "kikainekoHistory";

	private String usedClassesFieldName = "kikainekoUsedConcreteClasses";

	private String message1 = "//TODO To change.Mock Part Start ...";

	private String message2 = "//TODO To change.Mock Part End.";

	protected StringBuffer code;

	public Implementer(TargetClass tc) throws Exception {
		this.targetClass = tc;
		targetClass.checking();
		code = new StringBuffer();
		make();
	}

	public File getTargetFile() {
		String targetFileName = targetClass.getPack().replace('.', '\\') + "\\"
				+ targetClass.getClassName() + LangMgn.getSuffix();
		return new File(targetFileName);
	}

	private void make() throws Exception {
		head();
		body();
		returnMethod();
		kikainekoHistoriesTerms();
		usedClasses();

		kikainekoSeparation();

		kikainekoHistoryAddMethod();
		kikainekoSeekSimularHistoryTermMethod();
		kikainekoGetDegreeOfSimilarityMethod();
		kikainekoMakeHistoryTermMethod();
		
		kikainekoIndexOfHisMethod();
		kikainekoReturnMethod();
		kikainekoEqulaStringArraysMethod();

		kikainekoSeekingHistoryMethod();
		kikainekoBackwardMatchAndChangeHistoryMethod();
		kikainekoGetEndsWithAndShortHistoriesMethod();
		kikainekoGetEndsWithAndSameLengthHistoriesMethod();
		kikainekoSameHistoryTermAndChangeHistoryMethod();
		footer();
	}

	public String getCode() {
		return code.toString();
	}

	private void usedClasses() {
		code.append("private final Class[] ");
		code.append(usedClassesFieldName);
		code.append(" ={");
		Class[] cs = targetClass.getUsedConcreteClasses();
		for (int i = 0; i < cs.length; i++) {
			code.append(LangMgn.getClassName(cs[i]));
			code.append(".class");
			if (i != cs.length - 1)
				code.append(",");
		}
		code.append(" };\n\n");
	}

	/**
	 * 
	 */
	private void body() throws Exception {
		for (int i = 0; i < targetClass.howManyMethods(); i++) {
			methodBody(i);
		}
	}

	private void methodBody(int index) throws Exception {
		int numOfArgs = 0;
		String methodSig = targetClass.getMethodName(index);
		int indexOfOpenKakko = methodSig.indexOf('(');
		String name = methodSig.substring(0, indexOfOpenKakko);
		String reType = "";
		if (!name.equals(targetClass.getClassName())) {
			reType = targetClass.getReturnType(index);
			if (reType.equals(" ")) {
				reType = "void";
			}
		}
		code.append(targetClass.getMethodVisible(index));
		code.append(" ");
		code.append(reType);
		code.append(" ");
		code.append(name);
		code.append("(");
		if (methodSig.length() - indexOfOpenKakko > 2) {
			StringTokenizer st = new StringTokenizer(methodSig.substring(
					indexOfOpenKakko + 1, methodSig.length() - 2));
			while (st.hasMoreTokens()) {
				String s = st.nextToken();
				if (s.startsWith("[")) {
					code.append(LangMgn.arrayType(s));
				} else {
					code.append(s);
				}
				code.append(" arg");
				code.append(numOfArgs++);

				if (st.hasMoreTokens()) {
					code.append(",");
				}
			}
		}
		code.append(")");

		String[] exceptions = targetClass.getTargetMethodException(index);
		// \bhŗO𓊂ꍇ
		if (exceptions.length > 0) {
			code.append("throws " + exceptions[0]);
		}
		for (int i = 1; i < exceptions.length; i++) {
			code.append(" ," + exceptions[i]);
		}

		code.append("{\n");
		code.append(message1);
		code.append("\n");

		if (reType.length() == 0) {
			code.append(historyFieldName);
			code.append("=new java.util.Vector();\n\n");
		}

		code.append("String[] args={\n");
		if (numOfArgs != 0) {
			for (int j = 0; j < numOfArgs - 1; j++) {
				code.append("org.kikaineko.mock.util.ToStringer.get(");
				code.append("arg");
				code.append(j);
				code.append(")");
				code.append(",");
			}
			code.append("org.kikaineko.mock.util.ToStringer.get(");
			code.append("arg");
			code.append(numOfArgs - 1);
			code.append(")");
		}
		code.append("};\n");

		code.append("Object[] cond=");
		code.append(historyMethodName);
		code.append("(\"");
		code.append(targetClass.getMethodName(index));
		code.append("\",args);\n");

		code.append("String res=kikainekoReturn(cond,");
		code.append(targetClass.isDestoryMethod(index));
		code.append(");\n");
		code.append(message2);
		code.append("\n\n");

		// O
		if (targetClass.hasTargetMethodException(index)) {
			exception(index);
		}

		returnLogic(reType, index);
		code.append("\n}\n");
	}

	private void innerClassWrite(int index) throws Exception {
		String methodNameToStringed = targetClass.getMethodName(index);
		UndefinedValue[] uvs = targetClass.getUndefValues();
		for (int i = 0; i < uvs.length; i++) {
			if (methodNameToStringed.equals(uvs[i]
					.getMethodNameGeneratingThisUndefValue())) {
				code.append("if(res.equals(\""
						+ ToStringer.getStrick(uvs[i], null) + "\")){");
				InnerClassImplementer ici = new InnerClassImplementer(FilterMgn
						.doFilter(uvs[i]));
				code.append(ici.getCode());
				code.append("}");
			}
		}

	}

	private void returnLogic(String reType, int index) throws Exception {
		if (reType.length() == 0 || reType.equals("void"))
			return;
		String s = funcReturn(reType);
		code.append("try{\n");

		// NX
		if (targetClass.hasUndefValue()) {
			innerClassWrite(index);
		}

		code.append("\n " + s + "\n");
		code.append("}catch(Exception e){\n");
		code.append("res=\"(0)\";\n");
		code.append(s + "\n");
		code.append("}\n");

	}

	private void exception(int index) {
		String[] exceptions = targetClass.getTargetMethodException(index);
		for (int i = 0; i < exceptions.length; i++) {
			code.append("if(res.equals(\"throw new ");
			code.append(exceptions[i]);
			code.append("\")){");
			code.append("throw new " + exceptions[i] + "();");
			code.append("}");
		}
	}

	private String funcReturn(String reType) {
		if (reType.length() == 0 || reType.equals("void"))
			return "";
		else if (reType.equals("int"))
			return "return org.kikaineko.mock.util.ReturnValue.intValue(res);";
		else if (reType.equals("float"))
			return "return org.kikaineko.mock.util.ReturnValue.floatValue(res);";
		else if (reType.equals("long"))
			return "return org.kikaineko.mock.util.ReturnValue.longValue(res);";
		else if (reType.equals("double"))
			return "return org.kikaineko.mock.util.ReturnValue.doubleValue(res);";
		else if (reType.equals("char"))
			return "return org.kikaineko.mock.util.ReturnValue.charValue(res);";
		else if (reType.equals("boolean"))
			return "return org.kikaineko.mock.util.ReturnValue.booleanValue(res);";
		else if (reType.equals("byte"))
			return "return org.kikaineko.mock.util.ReturnValue.byteValue(res);";
		else if (reType.equals("short"))
			return "return org.kikaineko.mock.util.ReturnValue.shortValue(res);";
		else if (reType.equals("java.lang.String"))
			return "return org.kikaineko.mock.util.ReturnValue.stringValue(res);";
		else
			return "return (" + reType
					+ ")org.kikaineko.mock.util.ReturnValue.getObject("
					+ "res," + usedClassesFieldName + ");";
	}

	/**
	 * 
	 */
	protected void footer() {
		code.append("}");
	}

	protected void head() {
		code.append(targetClass.getPackForSorce() + "\n\n");
		code.append("/**\n");
		code.append("*\n");
		code.append("* @author KikainekoMocker v");
		code.append(Version.version);
		code.append(" at ");
		code.append(DateFormat.getDateTimeInstance(DateFormat.MEDIUM,
				DateFormat.MEDIUM).format(new Date()));
		code.append(" \n");
		code.append("*\n");
		code.append("* TODO To change.This is mock.\n");
		code.append("*/\n");
		code.append("public class ");
		code.append(targetClass.getClassName());

		if (targetClass.hasSuperClass()) {
			if (targetClass.getSuperClass().isInterface()) {
				code.append(" implements ");
				code.append(targetClass.getSuperClass().getName());
			} else {
				code.append(" extends ");
				code.append(targetClass.getSuperClass().getName());
			}
		}

		code.append(" {\n");
		code.append("private java.util.Vector ");
		code.append(historyFieldName);
		code.append("=new java.util.Vector();\n\n");
	}

	private void returnMethod() {
		code.append("private final String[][] kikainekoHistories={\n");
		for (int i = 0; i < targetClass.howManyHistories() - 1; i++) {
			code
					.append(targetClass
							.getHistoryAsStringArrayExpressionWithoutUndestroyMethod(i));
			code.append(",");
		}
		if (targetClass.howManyHistories() != 0) {
			code
					.append(targetClass
							.getHistoryAsStringArrayExpressionWithoutUndestroyMethod(targetClass
									.howManyHistories() - 1));
		}
		code.append("};\n\n");

		code.append("private final String[] kikainekoRes={\n");
		for (int i = 0; i < targetClass.howManyHistories() - 1; i++) {
			code.append("\"");
			code.append(targetClass.getValueAtHistory(i));
			code.append("\",");
		}
		code.append("\"");
		if (targetClass.howManyHistories() != 0) {
			code.append(targetClass.getValueAtHistory(targetClass
					.howManyHistories() - 1));
		}
		code.append("\"};\n\n");

	}

	private void kikainekoHistoriesTerms() {
		Vector vec = new Vector();
		for (int i = 0; i < targetClass.howManyHistories(); i++) {
			String[] ss = targetClass.getHistoryTermsOnHistoryAt(i);
			for (int j = 0; j < ss.length; j++) {
				if (!vec.contains(ss[j])) {
					vec.add(ss[j]);
				}
			}
		}
		code.append("\n");
		code.append("private final String[][] kikainekoHistoriesTerms = {\n");
		for (int i = 0; i < vec.size() - 1; i++) {
			code.append(vec.get(i) + ",");
		}
		if (vec.size() != 0) {
			code.append(vec.get(vec.size() - 1));
		}
		code.append("};\n");

	}

	private void kikainekoSeparation() {
		code
				.append("\n\n// ************** kikaineko methods **********************************//\n\n");
	}

	private void kikainekoHistoryAddMethod() {
		code.append("private Object[] ");
		code.append(historyMethodName);
		code.append("(String name, String[] args) {\n");
		code
				.append("String temp =  kikainekoSeekSimularHistoryTerm(name, args);\n");
		code.append("kikainekoHistory.add(temp);\n");
		code.append("Object[] responce = kikainekoHistory.toArray();\n");
		code.append("return responce;");
		code.append("}");
	}

	private void kikainekoSeekSimularHistoryTermMethod() {
		code
				.append("private String kikainekoSeekSimularHistoryTerm(String name, String[] args) {");
		code.append("double max = -1;");
		code.append("int index = -1;");
		code
				.append("for (int i = 0; i < kikainekoHistoriesTerms.length; i++) {");
		code.append("if (kikainekoHistoriesTerms[i][0].startsWith(name)) {");
		code
				.append("double flag = kikainekoGetDegreeOfSimilarity(kikainekoHistoriesTerms[i],args);");
		code.append("if (flag > max) {");
		code.append("max = flag;");
		code.append("index = i;");
		code.append("}");
		code.append("}");
		code.append("}");
		code.append("try{");
		code.append("return kikainekoMakeHistoryTerm(kikainekoHistoriesTerms[index]);");
		code.append("}catch(Exception e){");
		code.append("return \"\";");
		code.append("}");
		code.append("}");
	}

	private void kikainekoGetDegreeOfSimilarityMethod() {
		code
				.append("private double kikainekoGetDegreeOfSimilarity(String[] expecteds, String[] actuals) {");
		code.append("if ((expecteds.length - 1) != actuals.length) {");
		code.append("return 0;");
		code.append("}");
		code.append("if (actuals.length == 0) {");
		code.append("return 1;");
		code.append("}");
		code.append("double count = 0;");
		code.append("for (int i = 1; i < expecteds.length; i++) {");
		code.append("if (expecteds[i].equals(actuals[i - 1])) {");
		code.append("count += 1.0;");
		code.append("}}");
		code.append("return count / actuals.length;}");
	}

	private void kikainekoMakeHistoryTermMethod() {
		code.append("private String kikainekoMakeHistoryTerm(String[] args) {");
		code.append("String temp = args[0];");
		code.append("if (args.length != 1) {");
		code.append("temp += \"(\";");
		code.append("for (int i = 1; i < args.length; i++) {");
		code.append("temp += args[i] + \" \";");
		code.append("}");
		code.append("temp += \")\";");
		code.append("}");
		code.append("temp += \";\";");
		code.append("return temp;");
		code.append("}");
	}

	private void kikainekoReturnMethod() {
		code
				.append("private String kikainekoReturn(Object[] arg, boolean isDestroy) {\n");
		code.append("String res = \"\";\n");
		code.append("int index = kikainekoIndexOfHis(arg);\n");
		code.append("if (index == -1) {\n");
		code.append("res = \"(0)\";\n");
		code.append("} else {\n");
		code.append("res = kikainekoRes[index];\n");
		code.append("}\n");
		code.append("if (!isDestroy)\n");
		code.append("kikainekoHistory.remove(kikainekoHistory.size() - 1);\n");
		code.append("return res;\n");
		code.append("}\n");

	}

	private void kikainekoIndexOfHisMethod() {
		code.append("private int kikainekoIndexOfHis(Object[] args){ \n");
		code.append("for(int i=0;i<kikainekoHistories.length;i++){\n");
		code
				.append("if(kikainekoEqulaStringArrays(kikainekoHistories[i], args)) return i;\n");
		code.append("}\n");
		code.append("return kikainekoSeekingHistory(args);}\n");
	}

	private void kikainekoEqulaStringArraysMethod() {
		code
				.append("private boolean kikainekoEqulaStringArrays(String[] arg1,Object[] arg2){\n");
		code.append("if(arg1.length!=arg2.length)\n");
		code.append("return false;\n");
		code.append("for (int i = 0; i < arg1.length; i++) {\n");
		code.append("if(!arg1[i].equals(arg2[i])){\n");
		code.append("return false;\n");
		code.append("}}");
		code.append("return true;}\n");
	}

	// *************** beyond the test **********************//

	private void kikainekoSeekingHistoryMethod() {
		code.append("private int kikainekoSeekingHistory(Object[] args) {\n");

		code
				.append("java.util.Vector indexs = kikainekoGetEndsWithAndSameLengthHistories(args);\n");
		code.append("Object[] tempArgs = null;\n");
		code.append("if (indexs.size() > 0) {\n");
		code.append("tempArgs = (Object[]) args.clone();\n");
		code.append("}\n");
		code.append("for (int i = 0; i < indexs.size(); i++) {\n");
		code
				.append("String[] tempHistory = kikainekoHistories[((Integer) indexs.get(i)).intValue()];\n");
		code.append("if (kikainekoSameHistoryTermAndChangeHistory(tempArgs,\n");
		code.append("(String[]) tempHistory.clone()))\n");
		code.append("return ((Integer) indexs.get(i)).intValue();\n");
		code.append("}\n");

		code.append("indexs = kikainekoGetEndsWithAndShortHistories(args);\n");
		code.append("for (int i = args.length - 1; i >= 0; i--) {\n");
		code.append("for (int j = 0; j < indexs.size(); j++) {\n");
		code
				.append("String[] tempHistory = kikainekoHistories[((Integer)indexs.get(j)).intValue()];\n");
		code.append("if (i == tempHistory.length) {\n");
		code
				.append("if (kikainekoBackwardMatchAndChangeHistory(tempHistory))\n");
		code.append("return ((Integer) indexs.get(j)).intValue();\n");
		code.append("}}}\n");
		code.append("return -1;\n");
		code.append("}\n");
	}

	private void kikainekoBackwardMatchAndChangeHistoryMethod() {
		code
				.append("private boolean kikainekoBackwardMatchAndChangeHistory(String[] tempHistory) {\n");
		code
				.append("java.util.Vector temp = (java.util.Vector) kikainekoHistory.clone();\n");
		code.append("int delta = temp.size() - tempHistory.length;\n");
		code.append("for (int i = 0; i < delta; i++) {\n");
		code.append("temp.remove(0);\n");
		code.append("}\n");
		code
				.append("if (kikainekoEqulaStringArrays(tempHistory, temp.toArray())) {\n");
		code.append("kikainekoHistory=temp;\n");
		code.append("return true;\n");
		code.append("}\n");
		code.append("return false;\n");
		code.append("}\n");
	}

	private void kikainekoGetEndsWithAndShortHistoriesMethod() {
		code
				.append("private java.util.Vector kikainekoGetEndsWithAndShortHistories(Object[] args) {\n");
		code.append("java.util.Vector temp = new java.util.Vector();\n");
		code.append("String lastMethod = (String) args[args.length - 1];\n");
		code.append("for (int i = 0; i < kikainekoHistories.length; i++) {\n");
		code.append("String[] tempHistory = kikainekoHistories[i];\n");
		code
				.append("if (lastMethod.equals(tempHistory[tempHistory.length - 1])) {\n");
		code.append("if (tempHistory.length < args.length) {\n");
		code.append("temp.add(new Integer(i));\n");
		code.append("}}}\n");
		code.append("return temp;\n");
		code.append("}\n");
	}

	private void kikainekoGetEndsWithAndSameLengthHistoriesMethod() {
		code
				.append("private java.util.Vector kikainekoGetEndsWithAndSameLengthHistories(\n");
		code.append("Object[] args) {\n");
		code.append("java.util.Vector temp = new java.util.Vector();\n");
		code.append("String lastMethod = (String) args[args.length - 1];\n");
		code.append("for (int i = 0; i < kikainekoHistories.length; i++) {\n");
		code.append("String[] tempHistory = kikainekoHistories[i];\n");
		code
				.append("if (lastMethod.equals(tempHistory[tempHistory.length - 1])) {\n");
		code.append("if (tempHistory.length == args.length) {\n");
		code.append("temp.add(new Integer(i));\n");
		code.append("}\n");
		code.append("}\n");
		code.append("}\n");
		code.append("return temp;\n");
		code.append("}\n");

	}

	private void kikainekoSameHistoryTermAndChangeHistoryMethod() {
		code
				.append("private boolean kikainekoSameHistoryTermAndChangeHistory(Object[] temp1,\n");
		code.append("String[] args2) {\n");
		code.append("String[] temp2 = (String[]) args2.clone();\n");
		code.append("java.util.Arrays.sort(temp1);\n");
		code.append("java.util.Arrays.sort(temp2);\n");
		code.append("for (int i = 0; i < temp1.length; i++) {\n");
		code.append("if (!temp1[i].equals(temp2[i]))\n");
		code.append("return false;\n");
		code.append("}\n");
		code.append("java.util.Vector temp = new java.util.Vector();\n");
		code.append("for (int i = 0; i < args2.length; i++) {\n");
		code.append("temp.add(args2[i]);\n");
		code.append("}\n");
		code.append("kikainekoHistory = temp;\n");
		code.append("return true;\n");
		code.append("}\n");
	}

}