/*
 * 쐬F 2005/03/15
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.util;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;

import org.kikaineko.source.util.Token;

import fortest.TokenChild;
import fortest.returnvalueandtostringer.Foo;
import fortest.returnvalueandtostringer.FooImpl;
import fortest.returnvalueandtostringer.FooUser;


import junit.framework.TestCase;

/**
 * @author masayuki
 * 
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB EBhE  ݒ  Java  R[hEX^C 
 * R[hEev[g
 */
public class ReturnValueTest extends TestCase {

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    public void testInt̔z(){
    	int[] is={10,20};
    	String str=ToStringer.getStrick(is,null);
    	int[] is2=(int[])ReturnValue.getObject(str);
    	assertEquals(2, is2.length);
    	assertEquals(10, is2[0]);
    	assertEquals(20, is2[1]);
    }
    
    public void testOĂ݂(){
    	assertEquals(0,ReturnValue.intValue("(0)"));
    	assertEquals(0l,ReturnValue.longValue("(0)"));
    	assertEquals(0f,ReturnValue.floatValue("(0)"),0f);
    	assertEquals(0d,ReturnValue.doubleValue("(0)"),0d);
    	assertEquals("0",ReturnValue.stringValue("(0)"));
    	assertNull(ReturnValue.getObject("(0)"));
    }
    
    /**
     * @IGNORE
     * ł͗
     *
     */
	public void estBufferedWriter͓ŏzQƂĂ邪ꂪ[vɗĐł邩(){
		BufferedWriter b=new BufferedWriter(new OutputStreamWriter(System.out));
		String s=ToStringer.getStrick(b,null);
		BufferedWriter b1=(BufferedWriter)ReturnValue.getObject(s);
		assertNotNull(b1);
	}

    public void testpȂ() {
        TokenChild tc = new TokenChild(1);
        tc.setKind(99);
        String s = ToStringer.getStrick(tc,null);
        TokenChild tc2 = (TokenChild) ReturnValue.getObject(s);
        assertEquals(tc.getVal(), tc2.getVal());
        assertEquals(tc.getI(), tc2.getI());
        assertEquals(tc.getKind(), tc2.getKind());
    }

    public void testk֌W`FbN() {
        String s = "";
        String s2 = (String) ReturnValue.getObject(ToStringer.get(s));
        assertEquals(s, s2);
        s = null;
        s2 = (String) ReturnValue.getObject(ToStringer.get(s));
        assertEquals(s, s2);
        int i=0;
        int j=ReturnValue.intValue(ToStringer.get(i));
        assertEquals(i,j);
        i=-1;
        j=ReturnValue.intValue(ToStringer.get(i));
        assertEquals(i,j);
    }
    
    public void testGXP[v֌W`FbN(){
        String s = "\\";
        String s2 = (String) ReturnValue.getObject(ToStringer.get(s));
        assertEquals(s, s2);
        s = "@0";
        s2 = (String) ReturnValue.getObject(ToStringer.get(s));
        assertEquals(s, s2);
        s = "@@@/@@@@@000\\@ @@\\@@  ";
        s2 = (String) ReturnValue.getObject(ToStringer.get(s));
        assertEquals(s, s2);
        s = "./*\\[]-+<>;:\"\'%&(){}!#,@^~| ";
        s2 = (String) ReturnValue.getObject(ToStringer.get(s));
        assertEquals(s, s2);
    }

    public void testVector() {
        Vector vec = new Vector();
        vec.add("@BL");
        vec.add("h");
        String s = ToStringer.getStrick(vec,null);
        Vector vec2 = (Vector) ReturnValue.getObject(s);
        assertEquals("@BL", (String) vec2.get(0));
        assertEquals("h", (String) vec2.get(1));
    }

    public void testToken() {
        Token t1 = new Token(1, "2");
        Token t2 = (Token) ReturnValue
                .getObject("org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2))");
        assertEquals(t1.getVal(), t2.getVal());
    }

    public void testObject() {
        Token t = new Token(1, "1");
        Token t2 = (Token) ReturnValue.getObject(ToStringer.getStrick(t,null));
        assertEquals(t.getVal(), t2.getVal());
        assertEquals(t.getKind(), t2.getKind());

        Integer i1 = new Integer(1);
        Integer i2 = (Integer) ReturnValue.getObject(ToStringer.getStrick(i1,Integer.class));
        assertEquals(i1, i2);

        StringBuffer sb1 = new StringBuffer("hoge");
        StringBuffer sb2 = (StringBuffer) ReturnValue.getObject(ToStringer
                .getStrick(sb1,null));
        assertEquals(sb1.toString(), sb2.toString());

    }

    public void testRXgN^ɃC^[tF[XKvȂ̂ł邩() {
        Foo foo = new FooImpl();
        FooUser foouser = new FooUser(foo);
        Class[] cs = { FooImpl.class };
        FooUser f2 = (FooUser) ReturnValue.getObject(ToStringer.getStrick(foouser,null),
                cs);
        assertNotNull(f2);

        Calendar cal = Calendar.getInstance();
        Class[] cs2 = { GregorianCalendar.class };
        Calendar cal2 = (Calendar) ReturnValue.getObject(ToStringer.getStrick(cal,null),
                cs2);
        assertNotNull(cal2);
        //assertEquals(cal.toString(), cal2.toString());
    }

    public void testArray() {
        String[] ss = { "", "()" };
        String s = ToStringer.getStrick(ss,null);
        String[] ss2 = (String[]) ReturnValue.getObject(s);
        assertEquals(ss.length, ss2.length);
        assertEquals(ss[0], ss2[0]);
        assertEquals(ss[1], ss2[1]);
    }

    public void testx̂𕪊() {
        String s = "aho()";
        String[] ss = ReturnValue.getSameLevelStrings(s);
        assertEquals("aho()", ss[0]);

        s = "aho(boke()nasu())";
        ss = ReturnValue.getSameLevelStrings(s);
        assertEquals("aho(boke()nasu())", ss[0]);

        s = "org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))";
        ss = ReturnValue.getSameLevelStrings(s);
        assertEquals(1, ss.length);

        s = "boolean(false)int(1)java.lang.String(2)";
        ss = ReturnValue.getSameLevelStrings(s);
        assertEquals("boolean(false)", ss[0]);
        assertEquals("int(1)", ss[1]);
        assertEquals("java.lang.String(2)", ss[2]);
    }

    public void testJbRƂȊOɕ() {
        String s = "org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))";
        Vector ss = ReturnValue.getƃk\ƂȊOɕ̔z(s);
        assertEquals("org.kikaineko.source.util.Token", ss.get(0));
        assertEquals("(", ss.get(1));
        assertEquals("boolean", ss.get(2));
        assertEquals("(", ss.get(3));
        assertEquals("false", ss.get(4));
        assertEquals(")", ss.get(5));
        assertEquals("int", ss.get(6));
        assertEquals("(", ss.get(7));
        assertEquals("1", ss.get(8));
        assertEquals(")", ss.get(9));
        assertEquals("java.lang.String", ss.get(10));
        assertEquals("(", ss.get(11));
        assertEquals("2", ss.get(12));
        assertEquals(")", ss.get(13));
        assertEquals(")", ss.get(14));

        s = "aho(String(@())";
        ss = ReturnValue.getƃk\ƂȊOɕ̔z(s);
        assertEquals("aho", ss.get(0));
        assertEquals("(", ss.get(1));
        assertEquals("String", ss.get(2));
        assertEquals("(", ss.get(3));
        assertEquals("@(", ss.get(4));
        assertEquals(")", ss.get(5));
        assertEquals(")", ss.get(6));

        s = "aho([String(@0@0))";
        ss = ReturnValue.getƃk\ƂȊOɕ̔z(s);
        assertEquals("aho", ss.get(0));
        assertEquals("(", ss.get(1));
        assertEquals("[String", ss.get(2));
        assertEquals("(", ss.get(3));
        assertEquals("@0", ss.get(4));
        assertEquals("@0", ss.get(5));
        assertEquals(")", ss.get(6));
        assertEquals(")", ss.get(7));

    }

    public void testGetTypeAndValue() {
        String s = "org.kikaineko.source.util.Token(boolean(false)int(1)java.lang.String(2))";
        String[] ss = ReturnValue.getTypeAndValue(s);
        assertEquals("org.kikaineko.source.util.Token", ss[0]);
        assertEquals("boolean(false)int(1)java.lang.String(2)", ss[1]);
    }

    public void testGetTypeAndValueɋ󕶎̓zĂ݂() {
        String s = "java.lang.String()";
        String[] ss = ReturnValue.getTypeAndValue(s);
        assertEquals("java.lang.String", ss[0]);
        assertEquals("", ss[1]);
    }

    public void testString() {
        assertEquals("aho", ReturnValue.stringValue(ToStringer.get("aho")));
    }

    public void testPrimit() {
        String s = ToStringer.get(101);//int(101)
        assertEquals(101, ReturnValue.intValue(s));
        assertEquals('c', ReturnValue.charValue(ToStringer.get('c')));
        assertEquals(10l, ReturnValue.longValue(ToStringer.get(10l)));
        assertEquals(1.0f, ReturnValue.floatValue(ToStringer.get(1.0f)), 0);
        assertEquals(1.0d, ReturnValue.doubleValue(ToStringer.get(1.0d)), 0);

        assertEquals((byte) 1, ReturnValue.byteValue(ToStringer.get((byte) 1)));
        assertEquals((short) 1, ReturnValue.shortValue(ToStringer
                .get((short) 1)));

        assertEquals(false, ReturnValue.booleanValue(ToStringer.get(false)));
        assertEquals(true, ReturnValue.booleanValue(ToStringer.get(true)));
    }
}