package org.kikaineko.mock.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.Vector;

import org.kikaineko.source.util.Token;
import org.kikaineko.util.FileIO;

import fortest.Kara;
import fortest.TokenChild;
import fortest.returnvalueandtostringer.HogeToken;

import junit.framework.TestCase;

public class ToStringerTest extends TestCase {
    public void testLXgĂƂǂȂ邩(){
    	int[] is={1,2};
    	Integer[] is2={new Integer(1),new Integer(2)};
    	Object o=is;
    	assertEquals("[I(int(1)int(2))", ToStringer.getStrick(is,is.getClass()));
    	assertEquals("[I(int(1)int(2))", ToStringer.getStrick(o,o.getClass()));
    	Object[] os=new Object[1];
    	os[0]=o;
    	assertEquals("[I(int(1)int(2))", ToStringer.getStrick(os[0],os[0].getClass()));
    	assertEquals("[Ljava.lang.Integer;(java.lang.Integer(1)java.lang.Integer(2))", ToStringer.getStrick(is2,is2.getClass()));
    	assertEquals("int(1)", ToStringer.getStrick(new Integer(1),int.class));
    	assertEquals("java.lang.Integer(1)", ToStringer.getStrick(new Integer(1),Integer.class));
    }
    
	public void testPremit() {
		assertEquals("int(1)", ToStringer.get(1));

		assertEquals("double(1.0)", ToStringer.get(1.0));
		assertEquals("long(1)", ToStringer.get(1l));
		assertEquals("float(1.0)", ToStringer.get(1f));
		assertEquals("boolean(true)", ToStringer.get(true));
		assertEquals("boolean(false)", ToStringer.get(false));
		assertEquals("java.lang.String(test)", ToStringer.get("test"));
		assertEquals("char(" + String.valueOf((int) 'c') + ")", ToStringer
				.get('c'));

		assertEquals("char(0)", ToStringer.get((char) 0));

		assertEquals("byte(1)", ToStringer.get((byte) 1));
		assertEquals("short(1)", ToStringer.get((short) 1));
		
		
		assertEquals("int(1)", ToStringer.getStrick(new Integer(1),int.class));
		assertEquals("long(1)", ToStringer.getStrick(new Long(1l),long.class));
		assertEquals("double(1.0)", ToStringer.getStrick(new Double(1.0),double.class));
		assertEquals("float(1.0)", ToStringer.getStrick(new Float(1f),float.class));
		assertEquals("boolean(true)", ToStringer.getStrick(new Boolean(true),boolean.class));
		assertEquals("boolean(false)", ToStringer.getStrick(new Boolean(false),boolean.class));
		assertEquals("char(" + String.valueOf((int) 'c') + ")", ToStringer
				.getStrick(new Character('c'),char.class));

		assertEquals("char(0)", ToStringer.getStrick(new Character((char) 0),char.class));
		assertEquals("short(0)", ToStringer.getStrick(new Short((short) 0),short.class));
		assertEquals("byte(0)", ToStringer.getStrick(new Byte((byte) 0),byte.class));
		
	}

	public void testWrap() {
		assertEquals("java.lang.Integer(1)", ToStringer.getStrick(new Integer(1),Integer.class));

		assertEquals("java.lang.Double(1.0)", ToStringer.getStrick(new Double(1.0),Double.class));
		assertEquals("java.lang.Long(1)", ToStringer.getStrick(new Long(1l),Long.class));
		assertEquals("java.lang.Float(1.0)", ToStringer.getStrick(new Float(1f),Float.class));
		assertEquals("java.lang.Boolean(true)", ToStringer.getStrick(new Boolean(true),Boolean.class));
		assertEquals("java.lang.Boolean(false)", ToStringer.getStrick(new Boolean(false),Boolean.class));
		assertEquals("java.lang.Character(" + String.valueOf((int) 'c') + ")", ToStringer
				.getStrick(new Character('c'),Character.class));

		assertEquals("java.lang.Character(0)", ToStringer.getStrick(new Character((char) 0),Character.class));
		assertEquals("java.lang.Short(0)", ToStringer.getStrick(new Short((short) 0),Short.class));
		assertEquals("java.lang.Byte(0)", ToStringer.getStrick(new Byte((byte) 0),Byte.class));
	}
    public void testObjectwithoutToString() {
    	
        Token t = new Token(1, "2");
        assertEquals(
                "org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2))",
                ToStringer.getStrick(t,Token.class));
        assertEquals(
                "org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2))",
                ToStringer.getStrick(t,null));
        
        HogeToken h = new HogeToken(t);
        assertEquals(
                "fortest.returnvalueandtostringer.HogeToken(boolean(false)int(0)org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2)))",
                ToStringer.getStrick(h,HogeToken.class));
        assertEquals(
                "fortest.returnvalueandtostringer.HogeToken(boolean(false)int(0)org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2)))",
                ToStringer.getStrick(h,null));
        
        t = new Token(1, "2 3");
        assertEquals("org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2 3))", ToStringer.getStrick(t,Token.class));
        t = new Token(1, "(");
        assertEquals("org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(@())", ToStringer.getStrick(t,Token.class));
        
    }
    public void testSanit() {
        String s = " ";
        assertEquals("java.lang.String( )", ToStringer.get(s));
        s = " ab ";
        assertEquals("java.lang.String( ab )", ToStringer.get(s));
        s = " ab@";
        assertEquals("java.lang.String( ab@@)", ToStringer.get(s));
        s = "[]";
        assertEquals("java.lang.String(@[@])", ToStringer.get(s));
        s = "()";
        assertEquals("java.lang.String(@(@))", ToStringer.get(s));

    }
	public void testBufferedWriter͓ŏzQƂĂ邪ꂪ[vɗ擾ł邩(){
		BufferedWriter b=new BufferedWriter(new OutputStreamWriter(System.out));
		String s=ToStringer.getStrick(b,StringBuffer.class);
		FileIO.writeOutPutFile(new File("C:\\hoge1.txt"), s);
		assertFalse(s.startsWith("("));
		assertNotNull(s);
	}
    
    public void testpɃtB[hꍇ(){
        TokenChild tc=new TokenChild(1);
        String s=ToStringer.getStrick(tc,TokenChild.class);
        assertEquals("fortest.TokenChild(int(1)boolean(false)int(-1)int(0)java.lang.String(99))",s);
    }
    
    public void testVector(){
        String s=null;
        assertEquals("java.lang.String(@0)",ToStringer.get(s));
        
        Vector vec=new Vector();
        vec.add("@BL");
        vec.add("h");
        assertEquals("java.util.Vector(int(0)int(2)[Ljava.lang.Object;(java.lang.String(@BL)java.lang.String(h)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)))",ToStringer.getStrick(vec,Vector.class));
        
        
        vec=new Vector();
        vec.add(new Object());
        assertEquals("java.util.Vector(int(0)int(1)[Ljava.lang.Object;(java.lang.Object()java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)))",ToStringer.getStrick(vec,Vector.class));
        
    }
    public void testClass() {
        assertEquals("java.lang.Class(int)", ToStringer.get(int.class));
        assertEquals("java.lang.Class([I)", ToStringer.get(int[].class));
        assertEquals("java.lang.Class([[Ljava.lang.String;)", ToStringer.get(String[][].class));
    }
    
    public void testKara(){
        assertEquals("fortest.Kara()",ToStringer.getStrick(new Kara(),Kara.class));
    }
    public void testArr(){
        int[] arr_i={1,2};
        assertEquals("[I(int(1)int(2))",ToStringer.getStrick(arr_i,int[].class));
        int[][] ii = { { 1, 2 }, { 3, 4, 5, 6 } };
        assertEquals("[[I([I(int(1)int(2))[I(int(3)int(4)int(5)int(6)))", ToStringer.getStrick(ii,int[][].class));
        Object[] is2={new Integer(1),new Integer(2)};
        assertEquals("[I(int(1)int(2))",ToStringer.getStrick(is2,int[].class));
        Object[] ss={"aho","boke"};
        assertEquals("[Ljava.lang.String;(java.lang.String(aho)java.lang.String(boke))",ToStringer.getStrick(ss,String[].class));
    }


}
