package org.kikaineko.util;

import junit.framework.TestCase;

public class IntArrayTest extends TestCase {
	public void testĂv() {
		IntArray ia = new IntArray();
		for (int i = 0; i < 200; i++) {
			ia.add(i * 2);
		}
		assertEquals(200, ia.length());
		assertEquals(0, ia.get(0));
		assertEquals(200, ia.get(100));
		assertEquals(398, ia.get(199));
		assertEquals(398, ia.getLast());
	}

	public void testRs[() {
		IntArray ia = new IntArray();
		for (int i = 0; i < 10; i++) {
			ia.add(i * 2);
		}
		IntArray other = ia.createCopy();
		assertEquals(ia.length(), other.length());
		assertEquals(ia.get(0), other.get(0));
		for (int i = 0; i < 10; i++) {
			ia.add(i * 2);
		}
		assertEquals(20, ia.length());
		assertEquals(10, other.length());
	}

	public void testP̒l݂̂ǂ() {
		IntArray ia = new IntArray();
		assertTrue(ia.isUniq());
		for (int i = 0; i < 10; i++) {
			ia.add(0);
		}
		assertTrue(ia.isUniq());
		ia.add(1);
		for (int i = 0; i < 10; i++) {
			ia.add(0);
		}
		assertFalse(ia.isUniq());

	}

	public void testSubArray() {
		IntArray ia = new IntArray();
		for (int i = 0; i < 7; i++) {
			ia.add(i);
		}
		IntArray ia2 = ia.subArray(1, 5);
		assertEquals(4, ia2.length());
		assertEquals(1, ia2.get(0));
		assertEquals(4, ia2.get(3));


	}
}
