/*
 * 쐬F 2005/03/08
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.util.Stack;

import org.kikaineko.mock.analysis.innersi.Block;
import org.kikaineko.mock.analysis.innersi.BlockBody;
import org.kikaineko.mock.analysis.innersi.SharedFields;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.mock.framework.UndefinedValue;

/**
 * @author Masayuki Ioki
 * 
 * @BLbJ[̐SB ۂɉ͂sAbÑRA𐶐B
 */
public class SmallInterpreter implements Analyst {
	// SmallInterpreter̕ێtB[hSĈϏ
	protected SharedFields sf;

	public SmallInterpreter(TestClass tc, TargetClass tar) {
		sf = new SharedFields();
		sf.target = tar;
		sf.testClass = tc;
		sf.targetName = tar.getInstanceName();
		sf.classNameResolver = new ClassNameResolver(tc.packageName(), tc
				.getImports());
	}

	public void analyze() throws Exception {
		try {
			fieldsAnalyze();
			setFieldsInTestCase();
			for (int i = 0; i < sf.testClass.howManyTestMethods(); i++) {
				setUpanalyze();
				analyze(i);
				tearDownAnalyze();
				targetFlush();
			}
			setUsedClassesToTargets(sf.typeStack.pushedConcreteClasses());
		} catch (Exception e) {
			throw e;
		} catch (Throwable t) {
			throw new Exception("line  "
					+ sf.tokenArray.get(sf.index).getLineNo()
					+ " has a bad word.");
		}
	}

	protected void setFieldsInTestCase(){
		String[] names=sf.vt.getNames();
		for(int i=0;i<names.length;i++){
			sf.testClass.addFieldName(names[i]);
		}
	}
	
	protected void targetFlush(){
		sf.target.flush();
		targetInnerFlush(sf.target);
	}
	private void targetInnerFlush(TargetClass t){
		UndefinedValue[] uvs=t.getUndefValues();
		for(int i=0;i<uvs.length;i++){
			uvs[i].flush();
			targetInnerFlush(uvs[i]);
		}
	}
	protected void setUsedClassesToTargets(Class[] cs){
		setUsedClassesToTargetsInner(sf.target,cs);
	}
	private void setUsedClassesToTargetsInner(TargetClass t,Class[] cs){
		t.setUsedConcreteClasses(cs);
		UndefinedValue[] uvs = t.getUndefValues();
		for (int i = 0; i < uvs.length; i++) {
			setUsedClassesToTargetsInner(uvs[i],cs);
		}
	}

	protected void fieldsAnalyze() throws Exception {
		sf.vt = new VariableTable();
		sf.valueStack = new Stack();
		sf.typeStack = new TypeOwner();
		sf.tokenArray = sf.testClass.getFieldsPart();
		sf.currentLevel=0;
		sf.index=0;
		if (sf.tokenArray != null) {
			BlockBody.run(sf);
		}
		sf.fieldsVt = sf.vt;
	}

	protected void setUpanalyze() throws Exception {
		if (sf.fieldsVt != null) {
			sf.vt = sf.fieldsVt;
		} else {
			sf.vt = new VariableTable();
		}
		sf.valueStack = new Stack();
		sf.loopEndIndexStack = new Stack();
		sf.loopStartIndexStack = new Stack();
		sf.forConditionIndexStack=new Stack();
		sf.forIncrementStatementIndexStack =new Stack();
		sf.typeStack = new TypeOwner();
		
		sf.tokenArray = sf.testClass.getSetUp().getTokenArray();
		int index = sf.tokenArray.indexOfVal("{");
		index++;
		sf.index = index;

		Block.run(sf);

	}

	protected void tearDownAnalyze() throws Exception {
		sf.valueStack = new Stack();
		sf.loopEndIndexStack = new Stack();
		sf.loopStartIndexStack = new Stack();
		sf.forConditionIndexStack=new Stack();
		sf.forIncrementStatementIndexStack =new Stack();
		sf.typeStack = new TypeOwner(sf.typeStack.getPushedVec());
		sf.tokenArray = sf.testClass.getTearDown().getTokenArray();
		int index = sf.tokenArray.indexOfVal("{");
		index++;
		sf.index = index;

		Block.run(sf);
	}

	protected void analyze(int i) throws Exception {
		sf.loopEndIndexStack = new Stack();
		sf.loopStartIndexStack = new Stack();
		sf.forConditionIndexStack=new Stack();
		sf.forIncrementStatementIndexStack =new Stack();
		sf.valueStack = new Stack();
		sf.typeStack = new TypeOwner(sf.typeStack.getPushedVec());

		sf.tokenArray = sf.testClass.getTestMethod(i).getTokenArray();
		int index = sf.tokenArray.indexOfVal("{");
		index++;
		sf.index = index;

		Block.run(sf);
	}

	protected boolean isVariable(String s) {
		return SmallInterpreterSupportor.isVariable(sf.classNameResolver, s);
	}

	public TargetClass getTargetClass() {
		return sf.target;
	}

	public TestClass getTestClass() {
		return sf.testClass;
	}

	protected VariableTable getVariableTable() {
		return sf.vt;
	}
}