package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.source.util.TokenKind;

public class ForBlock {

	public static void run(SharedFields sf) throws Exception {
		// 
		sf.index++; // (
		initPart(sf);
		if (sf.tokenArray.getKind(sf.index) == TokenKind.SemiKoron) {
			sf.index++; // ;
		}

		if (sf.tokenArray.getKind(sf.index) == TokenKind.CloseKakko) {
			// )ǂނƂƂ́AȂ[v
			// ̏ꍇ͓ʈ

			// _~[l
			sf.forConditionIndexStack.push(new Integer(-1));
			sf.forIncrementStatementIndexStack.push(new Integer(-1));

			// [vǂ
			sf.loopStartIndexStack.push(new Integer(sf.index + 1));
			sf.index++;
			IgnoreContolStatementBlock.run(sf);
			
			sf.loopEndIndexStack.push(new Integer(sf.index));
			while (true) {
				sf.index = LoopBlockHelper.toStartIndex(sf);
				try {
					ControlStatementBlock.run(sf);
				} catch (BreakException be) {
					sf.index = LoopBlockHelper.toEndIndex(sf);
					tearDown(sf);
					return;
				}
			}
		} else if (sf.tokenArray.getKind(sf.index) == TokenKind.SemiKoron) {
			// ŃZ~RǂނƂƂ͏

			// _~[l
			sf.forConditionIndexStack.push(new Integer(-1));
			sf.forIncrementStatementIndexStack.push(new Integer(sf.index + 1));
			IgnoreOpenedKakko.run(sf);
			// [vǂ
			sf.loopStartIndexStack.push(new Integer(sf.index + 1));
			sf.index++;
			IgnoreContolStatementBlock.run(sf);
			// ̃ubN܂߂}cKv
			sf.loopEndIndexStack.push(new Integer(sf.index));

			while (true) {
				sf.index = LoopBlockHelper.toStartIndex(sf);
				try {
					ControlStatementBlock.run(sf);
					sf.index = LoopBlockHelper.toIncrementStatementIndex(sf);
					Statement.run(sf, sf.tokenArray.getVal(sf.index++));
				} catch (BreakException be) {
					sf.index = LoopBlockHelper.toEndIndex(sf);
					tearDown(sf);
					return;
				}
			}
		}

		// 
		sf.forConditionIndexStack.push(new Integer(sf.index));
		Expression.run(sf);
		boolean flag = Expression.toBoolean(sf);
		sf.index++;// ;

		// 
		sf.forIncrementStatementIndexStack.push(new Integer(sf.index));
		IgnoreOpenedKakko.run(sf);

		// [vǂ
		sf.loopStartIndexStack.push(new Integer(sf.index + 1));
		sf.index++;
		IgnoreContolStatementBlock.run(sf);
		
		sf.loopEndIndexStack.push(new Integer(sf.index));

		// Zbg
		sf.index = LoopBlockHelper.toStartIndex(sf);

		while (flag) {
			sf.index = LoopBlockHelper.toStartIndex(sf);
			try{
			ControlStatementBlock.run(sf);
			sf.index = LoopBlockHelper.toIncrementStatementIndex(sf);
			Statement.run(sf, sf.tokenArray.getVal(sf.index++));

			sf.index = LoopBlockHelper.toConditionIndex(sf);
			Expression.run(sf);
			flag = Expression.toBoolean(sf);
			}catch(BreakException be){
				sf.index = LoopBlockHelper.toEndIndex(sf);
				tearDown(sf);
			}
		}
		// }̏I܂Ŗ
		sf.index = LoopBlockHelper.toEndIndex(sf);
		tearDown(sf);
	}

	private static void tearDown(SharedFields sf) {
		sf.forConditionIndexStack.pop();
		sf.forIncrementStatementIndexStack.pop();
		sf.loopEndIndexStack.pop();
		sf.loopStartIndexStack.pop();
	}

	private static void initPart(SharedFields sf) throws Exception {
		String s = sf.tokenArray.getVal(sf.index++);
		if (!s.equals(sf.targetName) && LoopBlockHelper.isVariable(sf, s)) {

			if (sf.tokenArray.getVal(sf.index).equals(".")) {
				// ܂ł݂ȂƕȂ
				Statement.run(sf, s);
			} else {
				Class c = sf.classNameResolver.getClazz(s);
				Variable.run(sf, c);
			}
		} else {
			Statement.run(sf, s);
		}
	}

}
