package org.kikaineko.mock.analysis.innersi;

import java.util.Stack;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.framework.MethodInTestCase;
import org.kikaineko.mock.framework.TestClass;

public class MethodInTestCaseCalling {
	public static void run(SharedFields sf, String val) throws Exception {
		Object[] os = Arg.run(sf);
		sf.index++; // )
		Object[] vs = (Object[]) os[0];
		Class[] cs = (Class[]) os[1];

		String name = SmallInterpreterSupportor.getMethodSignature(cs, val);
		MethodInTestCase mitc = sf.testClass.getMethodInTestCase(name);
		if (mitc == null) {
			mitc = seachMethodInTestCase(sf, val, cs);
			mitc.setNameByToStringer(name);
		}
		String[] varNames = mitc.getArgsName();

		SharedFields sf2 = new SharedFields();
		sf2.target = sf.target;
		sf2.testClass = sf.testClass;
		sf2.targetName = sf.targetName;
		sf2.classNameResolver = sf.classNameResolver;

		sf2.vt = new VariableTable();
		sf2.valueStack = new Stack();
		sf2.loopEndIndexStack = new Stack();
		sf2.loopStartIndexStack = new Stack();
		sf2.forConditionIndexStack = new Stack();
		sf2.forIncrementStatementIndexStack = new Stack();
		sf2.typeStack = new TypeOwner();

		sf2.tokenArray = mitc.getTokenArray();
		int index = sf2.tokenArray.indexOfVal("{");
		index++;
		sf2.index = index;

		for (int i = 0; i < varNames.length; i++) {
			String s = varNames[i];
			sf2.vt.addByName(s);
			sf2.vt.setValAndLevel(s, vs[i], sf.currentLevel);
			sf2.vt.setType(s, cs[i]);
		}
		for (int i = 0; i < sf.testClass.howManyFieldsInTestCase(); i++) {
			String s = sf.testClass.getFieldNameInTestCase(i);
			sf2.vt.addByName(s);
			sf2.vt.setValAndLevel(s, sf.vt.getVal(s), sf.currentLevel);
			sf2.vt.setType(s, sf.vt.getType(s));
		}

		try {
			Block.run(sf2);
		} catch (ReturnException e) {
			if (!mitc.getReType().equals("void")) {
				sf.valueStack.push(sf2.valueStack.pop());
				sf.typeStack.push(sf2.typeStack.pop());
			}
		}
	}

	private static MethodInTestCase seachMethodInTestCase(SharedFields sf,
			String val, Class[] cs) {
		TestClass tc = sf.testClass;
		MethodInTestCase m;
		for (int i = 0; i < tc.howManyMethodsInTestCase(); i++) {
			m = tc.getMethodInTestCase(i);
			if (m.getName().startsWith(val)
					&& m.getArgsClass().length == cs.length) {
				if (canMuchClasses(sf,m.getArgsClass(), cs)) {
					return m;
				}
			}
		}
		return null;
	}

	private static boolean canMuchClasses(SharedFields sf,String[] argsClass, Class[] cs) {
		for(int i=0;i<argsClass.length;i++){
			Class c=sf.classNameResolver.getClazz(argsClass[i]);
			if(c !=cs[i]){
				return false;
			}
		}
		return true;
	}

}
