package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenKind;

public class Term {
	public static void run(SharedFields sf) throws Exception {
		Factor.run(sf);
		while (true) {
			Token t = sf.tokenArray.getToken(sf.index);
			if (t.getKind() == TokenKind.Star) {
				sf.index++;
				Factor.run(sf);
				SmallInterpreterSupportor.operation(sf.valueStack,
						sf.typeStack, "*");
			} else if (t.getKind() == TokenKind.Slash) {
				sf.index++;
				Factor.run(sf);
				SmallInterpreterSupportor.operation(sf.valueStack,
						sf.typeStack, "/");
			} else if (t.getKind() == TokenKind.Amari) {
				sf.index++;
				Factor.run(sf);
				SmallInterpreterSupportor.operation(sf.valueStack,
						sf.typeStack, "%");
			} else if (t.getKind() == TokenKind.Piriod) {
				if (sf.valueStack.peek() instanceof TargetClass) {
					TargetClass tempTarget = (TargetClass) sf.valueStack.pop();
					sf.typeStack.pop();
					// ŕslĂ΂ĂA^Ȃvoid^ɂĂ
					UndefinedValue undefV = UndefinedValue.getCompornent(
							void.class, "");
					TargetInvokingForUndefinedValue.run(sf, undefV, tempTarget);

					sf.valueStack.push(tempTarget);
					sf.typeStack.push(TargetClass.class);
				} else if (sf.vt.include(t.getVal())
						&& sf.vt.getVal(t.getVal()).getClass() == UndefinedValue.class) {
					TargetInvokingForUndefinedValue.run(sf,
							(UndefinedValue) sf.vt.getVal(t.getVal()),
							sf.target);
				} else {
					sf.index++;
					MethodCalling.run(sf, "method");
				}

			} else {
				break;
			}
		}
	}
}
