package org.kikaineko.mock.analysis.junit4;

import java.util.Stack;

import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.analysis.innersi.Block;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.mock.framework.junit4.TestClassForJunit4;

public class SmallInterpreterForJunit4 extends SmallInterpreter {
	public SmallInterpreterForJunit4(TestClass tc, TargetClass tar) {
		super(tc, tar);
	}

	public void analyze() throws Exception {
		try {
			fieldsAnalyze();
			setFieldsInTestCase();
			beforeClassAnalyze();
			for (int i = 0; i < sf.testClass.howManyTestMethods(); i++) {
				setUpanalyze();
				analyze(i);
				tearDownAnalyze();
				targetFlush();
			}
			afterClassAnalyze();
			setUsedClassesToTargets(sf.typeStack.pushedConcreteClasses());
		} catch (Exception e) {
			throw e;
		} catch (Throwable t) {
			throw new Exception("line  "
					+ sf.tokenArray.get(sf.index).getLineNo()
					+ " has a bad word.");
		}
	}

	private void afterClassAnalyze() throws Exception {
		sf.valueStack = new Stack();
		sf.loopEndIndexStack = new Stack();
		sf.loopStartIndexStack = new Stack();
		sf.forConditionIndexStack=new Stack();
		sf.forIncrementStatementIndexStack =new Stack();
		sf.typeStack = new TypeOwner(sf.typeStack.getPushedVec());
		sf.tokenArray = ((TestClassForJunit4)sf.testClass).getAfterClass().getTokenArray();
		int index = sf.tokenArray.indexOfVal("{");
		index++;
		sf.index = index;

		Block.run(sf);
	}

	private void beforeClassAnalyze() throws Exception {
		if (sf.fieldsVt != null) {
			sf.vt = sf.fieldsVt;
		} else {
			sf.vt = new VariableTable();
		}
		sf.valueStack = new Stack();
		sf.loopEndIndexStack = new Stack();
		sf.loopStartIndexStack = new Stack();
		sf.forConditionIndexStack = new Stack();
		sf.forIncrementStatementIndexStack = new Stack();
		sf.typeStack = new TypeOwner();

		sf.tokenArray = ((TestClassForJunit4)sf.testClass).getBeforeClass().getTokenArray();
		int index = sf.tokenArray.indexOfVal("{");
		index++;
		sf.index = index;
		if (sf.tokenArray != null)
			Block.run(sf);
	}
}
